/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.kex.tls.deabruf.par;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.kex.tls.deabruf.par.CsvLeser;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VewDeAbrufParameter
implements StandardApplication,
ClientSenderInterface {
    private static final String ASPEKT_SOLL = "asp.parameterSoll";
    private static final String ASPEKT_VORGABE = "asp.parameterVorgabe";
    private static final String ATG = "atg.paramTlsDeAbruf";
    private static final String TRENN_LINIE = "=======================================================================================\n";
    private static Debug debug = Debug.getLogger();
    private boolean _sendeErlaubnis = false;
    private DataDescription _datenBeschreibung;
    private ClientDavInterface _dav;
    private DataModel _davKonf;
    private String _parDatei;
    private String _parSoPid;
    private boolean _parUeberschreiben;
    private SystemObject _soDeAbruf;

    private void ausgabe(String string, List<Parameter> list) {
        StringBuilder stringBuilder = new StringBuilder(TRENN_LINIE);
        stringBuilder.append(string).append(":\n");
        for (Parameter parameter : list) {
            stringBuilder.append(parameter).append("\n");
        }
        stringBuilder.append(TRENN_LINIE);
        debug.info(stringBuilder.toString());
    }

    public void dataRequest(SystemObject systemObject, DataDescription dataDescription, byte by) {
        this._sendeErlaubnis = by == 0;
        String string = "unbekannter Status";
        if (by == 0) {
            string = "START_SENDING";
        } else if (by == 1) {
            string = "STOP_SENDING";
        } else if (by == 2) {
            string = "STOP_SENDING_NO_RIGHTS";
        } else if (by == 3) {
            string = "STOP_SENDING_NOT_A_VALID_SUBSCRIPTION";
        }
        debug.fine(String.format("SO: %s%nDatenbeschreibung: %s%nStatus: %s%n", systemObject, dataDescription, string));
    }

    public void initialize(ClientDavInterface clientDavInterface) throws Exception {
        this._dav = clientDavInterface;
        this._davKonf = this._dav.getDataModel();
        this._soDeAbruf = this._davKonf.getObject(this._parSoPid);
        if (this._soDeAbruf == null) {
            debug.error(String.format("Das Objekte mit dem PID <%s> kann nicht ermittelt werden!. Bitte pr\u00fcfen Sie den Aufrufparameter <-soDeAbrufPid>. Programm wird beendet.", this._parSoPid));
            throw new RuntimeException("Null-Objekt");
        }
    }

    public boolean isRequestSupported(SystemObject systemObject, DataDescription dataDescription) {
        return true;
    }

    private List<Parameter> ladeParameterAusDav() {
        debug.info(String.format("%s Lade  den Parametersatz aus DaV ...\n%s", TRENN_LINIE, TRENN_LINIE));
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        AttributeGroup attributeGroup = this._davKonf.getAttributeGroup(ATG);
        Aspect aspect = this._davKonf.getAspect(ASPEKT_SOLL);
        DataDescription dataDescription = new DataDescription(attributeGroup, aspect);
        ResultData resultData = this._dav.getData(this._soDeAbruf, dataDescription, 0L);
        if (resultData.hasData()) {
            Data.Array array = resultData.getData().getArray("DeAbrufParameter");
            for (int i = 0; i < array.getLength(); ++i) {
                Data data = array.getItem(i);
                String string = data.getReferenceValue("DeReferenz").getSystemObjectPid();
                int n = data.getUnscaledValue("ID").intValue();
                int n2 = data.getUnscaledValue("Typ").intValue();
                long l = data.getTimeValue("Intervall").getMillis();
                boolean bl = data.getTextValue("aktiviert").getText().equals("Ja");
                SystemObject systemObject = this._davKonf.getObject(string);
                if (systemObject != null) {
                    arrayList.add(new Parameter(systemObject, n, n2, l, bl));
                    continue;
                }
                debug.warning(String.format("DE mit der PID <%s> ist nicht ermittelbar", string));
            }
        } else {
            debug.warning(String.format("Parametersatz DE-Abruf ist leer.", new Object[0]));
        }
        this.ausgabe(String.format("Es wurden folgende <%d> Parameter-Eintr\u00e4ge aus DaV geladen", arrayList.size()), arrayList);
        return arrayList;
    }

    private List<Parameter> leseParameterAusDerCsvDatei() {
        debug.info(String.format("%s Leser  den Parametersatz aus der Datei \n<%s>...\n%s", TRENN_LINIE, this._parDatei, TRENN_LINIE));
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        boolean bl = false;
        File file = new File(this._parDatei);
        String string = "SO_PID";
        String string2 = "ID";
        String string3 = "TYP";
        String string4 = "INTERVALL_SEKUNDEN";
        String string5 = "AKTIVIERT";
        int n = 1;
        try {
            CsvLeser csvLeser = new CsvLeser(new FileReader(file), ';');
            while (csvLeser.hasNochMehrZeilen()) {
                Map<String, String> map = csvLeser.getNaechsteZeile();
                String string6 = map.get(string).trim();
                int n2 = Integer.valueOf(map.get(string2).trim());
                int n3 = Integer.valueOf(map.get(string3).trim());
                long l = Integer.valueOf(map.get(string4).trim()) * 1000;
                boolean bl2 = map.get(string5).trim().equals("ja");
                SystemObject systemObject = this._davKonf.getObject(string6);
                if (systemObject == null) {
                    debug.error(String.format("Unbekanntes SystemObject <%s> in der Zeile <%d>", string6, n));
                    bl = true;
                    break;
                }
                Parameter parameter = new Parameter(systemObject, n2, n3, l, bl2);
                arrayList.add(parameter);
                ++n;
            }
            csvLeser.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            debug.error(String.format("Datei <%s> kann nicht gefunden werden!", file), (Throwable)fileNotFoundException);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            debug.error(String.format("Fehler beim Einlesen der Datei <%s> in der Zeile <%d>.", file, n), (Throwable)numberFormatException);
            bl = true;
        }
        catch (Exception exception) {
            debug.error(String.format("Fehler beim Einlesen der Datei <%s> in der Zeile <%d>.", file, n), (Throwable)exception);
            bl = true;
        }
        if (bl) {
            return new ArrayList<Parameter>();
        }
        this.ausgabe(String.format("Es wurden folgende <%d> Parameter-Eintr\u00e4ge aus der Datei gelesen", arrayList.size()), arrayList);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        VewDeAbrufParameter vewDeAbrufParameter = new VewDeAbrufParameter();
        StandardApplicationRunner.run((StandardApplication)vewDeAbrufParameter, (String[])stringArray);
        debug = Debug.getLogger();
        vewDeAbrufParameter.sendeDeAbrufParameter();
        System.exit(0);
    }

    public void parseArguments(ArgumentList argumentList) throws Exception {
        block8: {
            String string = "-soDeAbrufPid";
            try {
                this._parSoPid = argumentList.fetchArgument(string).asNonEmptyString();
            }
            catch (Exception exception) {
                debug.error(String.format("Bitte die SystemObjekt-PID f\u00fcr den DE-Abruf als Parameter <%s> \u00fcbergeben!", string), (Throwable)exception);
                throw new RuntimeException(exception);
            }
            string = "-csvDatei";
            try {
                this._parDatei = argumentList.fetchArgument(string).asNonEmptyString();
            }
            catch (Exception exception) {
                debug.error(String.format("Bitte die csv-Datei mit Parameter-Daten als Parameter <%s> \u00fcbergeben!", string), (Throwable)exception);
                throw new RuntimeException(exception);
            }
            string = "-parameterUeberschreiben";
            try {
                String string2 = argumentList.fetchArgument(string).asNonEmptyString().toLowerCase();
                if (string2.equals("ja")) {
                    this._parUeberschreiben = true;
                    break block8;
                }
                if (string2.equals("nein")) {
                    this._parUeberschreiben = false;
                    break block8;
                }
                debug.error(String.format("Unzul\u00e4ssiger Wert f\u00fcr den Parameter <%s=%s> (darf nur <ja> oder <nein> sein)!", string, string2));
                throw new RuntimeException();
            }
            catch (Exception exception) {
                debug.error(String.format("Bitte den Parameter <%s> mit dem Wert <ja> oder <nein> \u00fcbergeben!", string), (Throwable)exception);
                throw new RuntimeException(exception);
            }
        }
    }

    private void sendeDeAbrufParameter() {
        int n;
        Parameter parameter;
        List<Parameter> list = !this._parUeberschreiben ? this.ladeParameterAusDav() : new ArrayList<Parameter>();
        List<Parameter> list2 = this.leseParameterAusDerCsvDatei();
        if (list2.isEmpty()) {
            debug.error("Die Liste der zu erstellten Parameter ist leer!");
            throw new RuntimeException();
        }
        list.addAll(list2);
        debug.info(String.format("%s Erstelle neuen Parametersatz ...\n%s", TRENN_LINIE, TRENN_LINIE));
        list2 = new ArrayList<Parameter>();
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (int i = list.size() - 1; i >= 0; --i) {
            parameter = list.get(i);
            if (list2.contains(parameter)) {
                arrayList.add(0, parameter);
                continue;
            }
            list2.add(parameter);
        }
        Collections.sort(list2, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter parameter, Parameter parameter2) {
                return parameter._de.getPidOrNameOrId().compareTo(parameter2._de.getPidOrNameOrId());
            }
        });
        if (!arrayList.isEmpty()) {
            this.ausgabe(String.format("Folgende <%d> Parameter-Eintr\u00e4ge wurden nicht ber\u00fccksichtigt (da sie mehrmals vorhanden sind)", arrayList.size()), arrayList);
        }
        this.ausgabe(String.format("Es sind folgende neue <%d> Parameter-Eintr\u00e4ge erstellt", list2.size()), list2);
        AttributeGroup attributeGroup = this._davKonf.getAttributeGroup(ATG);
        parameter = this._davKonf.getAspect(ASPEKT_VORGABE);
        this._datenBeschreibung = new DataDescription(attributeGroup, (Aspect)parameter);
        try {
            this._dav.subscribeSender((ClientSenderInterface)this, this._soDeAbruf, this._datenBeschreibung, SenderRole.sender());
        }
        catch (OneSubscriptionPerSendData oneSubscriptionPerSendData) {
            debug.error(String.format("Datenidentifikation ist bereits angemeldet. Eventuell Empf\u00e4nger nicht vorhanden: <%s>, <%s>. Programm wird beendet.", this._soDeAbruf, this._datenBeschreibung), (Throwable)oneSubscriptionPerSendData);
            throw new RuntimeException(oneSubscriptionPerSendData);
        }
        catch (Exception exception) {
            debug.error(String.format("Fehler bei der Anmeldung der Daten als Sender: <%s>, <%s>. Programm wird beendet.", this._soDeAbruf, this._datenBeschreibung), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        for (n = 0; n < 10 && !this._sendeErlaubnis; ++n) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this._sendeErlaubnis) {
            debug.error(String.format("Sendeerlaubnis ist nicht vorhanden: <%s>, <%s>", this._soDeAbruf, this._datenBeschreibung));
            throw new RuntimeException("Sendeerlaubnis ist nicht vorhanden");
        }
        Data data = this._dav.createData(attributeGroup);
        String string = this._parUeberschreiben ? "Neue Anlage des Parametersatzes" : "Erg\u00e4nzung des Parametersatzes";
        data.getItem("Urlasser").getTextValue("Ursache").setText(string);
        data.getItem("Urlasser").getTextValue("Veranlasser").setText("Tool zur Verwaltung des DE-Abruf-Parameters <de.bsvrz.kex.tls.deabruf.par>");
        Data.Array array = data.getArray("DeAbrufParameter");
        array.setLength(list2.size());
        for (n = 0; n < list2.size(); ++n) {
            Parameter parameter2 = list2.get(n);
            Data data2 = array.getItem(n);
            data2.getReferenceValue("DeReferenz").setSystemObject(parameter2._de);
            data2.getUnscaledValue("ID").set(parameter2._id);
            data2.getUnscaledValue("Typ").set(parameter2._typ);
            data2.getTimeValue("Intervall").setMillis(parameter2._intervall);
            data2.getTextValue("aktiviert").setText(parameter2._aktiviert ? "Ja" : "Nein");
        }
        ResultData resultData = new ResultData(this._soDeAbruf, this._datenBeschreibung, System.currentTimeMillis(), data, false);
        try {
            this._dav.sendData(resultData);
            debug.info(String.format("%s Es sind <%d> Eintr\u00e4ge f\u00fcr den DE-Abruf-Parameter erfolgreich gesendet.\n%s", TRENN_LINIE, list2.size(), TRENN_LINIE));
        }
        catch (Exception exception) {
            debug.error(String.format("Fehler beim Senden der Daten an DaV: <%s>, <%s>", this._soDeAbruf, this._datenBeschreibung), (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    private class Parameter {
        private boolean _aktiviert;
        private SystemObject _de;
        private int _id;
        private long _intervall;
        private int _typ;

        private Parameter(SystemObject systemObject, int n, int n2, long l, boolean bl) {
            this._de = systemObject;
            this._id = n;
            this._typ = n2;
            this._intervall = l;
            this._aktiviert = bl;
        }

        public boolean equals(Object object) {
            if (object instanceof Parameter) {
                Parameter parameter = (Parameter)object;
                return this._de.equals(parameter._de) && this._id == parameter._id && this._typ == parameter._typ;
            }
            return false;
        }

        private String getZeitdauerAlsString(long l) {
            long l2 = l / 3600000L;
            long l3 = (l - l2 * 60L * 60L * 1000L) / 60000L;
            float f = (float)(l - l2 * 60L * 60L * 1000L - l3 * 60L * 1000L) / 1000.0f;
            return String.format("%02d:%02d:%02d", l2, l3, Math.round(f));
        }

        public String toString() {
            return String.format("%-65s  %3d  %3d  %s  %s", this._de.getPidOrNameOrId(), this._id, this._typ, this.getZeitdauerAlsString(this._intervall), this._aktiviert);
        }
    }
}

