/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.InvalidationListener;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.MutableSetChangeListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.TMCVewMeldung;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.HashMap;
import java.util.Map;

public class TMCVerwaltung
implements MutableSetChangeListener,
InvalidationListener,
ClientReceiverInterface {
    private static final Debug DEBUG = Debug.getLogger();
    private ConfigurationObject lmsObjekt;
    public static final String TMCMELDUNGEN = "TMCMeldungen";
    private ClientDavInterface dav;
    private DataDescription datenBeschreibung;
    private Map<SystemObject, TMCVewMeldung> aktuelleMeldungen = new HashMap<SystemObject, TMCVewMeldung>();
    private long rdsMeldungsRueckhaltung = -1L;
    private String rdsMeldungsAktion;

    public TMCVerwaltung(ClientDavInterface connection, ConfigurationObject konfigObjekt, int optionen) {
        this.dav = connection;
        this.lmsObjekt = konfigObjekt;
        AttributeGroup atg = this.dav.getDataModel().getAttributeGroup("atg.tmcMeldungsVerwaltung");
        Aspect asp = this.dav.getDataModel().getAspect("asp.parameterSoll");
        this.datenBeschreibung = new DataDescription(atg, asp);
        this.dav.subscribeReceiver((ClientReceiverInterface)this, (SystemObject)this.lmsObjekt, this.datenBeschreibung, ReceiveOptions.normal(), ReceiverRole.receiver());
        DEBUG.config(this.datenBeschreibung + " zum Empfang angemeldet f\u00fcr " + this.lmsObjekt);
        MutableSet menge = this.lmsObjekt.getMutableSet(TMCMELDUNGEN);
        for (SystemObject obj : menge.getElements()) {
            if (!obj.isValid()) continue;
            this.initialisiereMeldung(obj);
        }
        menge.addChangeListener((MutableSetChangeListener)this);
        DEBUG.config("An Menge \"TMCMeldungen\" angemeldet");
        DEBUG.config(String.valueOf(this.aktuelleMeldungen.size()) + " TMC-Meldungsobjekt(e) initial verwaltet");
    }

    public TMCVerwaltung(ClientDavInterface connection, ConfigurationObject konfigObjekt) {
        this(connection, konfigObjekt, 0);
    }

    public void dispose() {
        this.lmsObjekt.getMutableSet(TMCMELDUNGEN);
        DEBUG.config("Von Menge \"TMCMeldungen\" abgemeldet");
        for (TMCVewMeldung meldung : this.aktuelleMeldungen.values()) {
            if (meldung.getDavObjekt() instanceof DynamicObject) {
                ((DynamicObject)meldung.getDavObjekt()).removeListenerForInvalidation((InvalidationListener)this);
                DEBUG.fine("Invalidation-Listener abgemeldet f\u00fcr " + meldung.getDavObjekt().getPid());
            }
            meldung.dispose();
        }
        this.aktuelleMeldungen.clear();
        this.dav.unsubscribeReceiver((ClientReceiverInterface)this, (SystemObject)this.lmsObjekt, this.datenBeschreibung);
        DEBUG.config("Empfang abgemeldet von " + this.datenBeschreibung + " f\u00fcr " + this.lmsObjekt);
    }

    public ClientDavInterface getConnection() {
        return this.dav;
    }

    public ConfigurationObject getKonfigObjekt() {
        return this.lmsObjekt;
    }

    public void update(MutableSet set, SystemObject[] addedObjects, SystemObject[] removedObjects) {
        SystemObject obj;
        int n;
        int n2;
        SystemObject[] systemObjectArray;
        DEBUG.fine("MutableSetChangeListener.update() von \"" + set.getName() + "\"");
        if (addedObjects.length > 0) {
            DEBUG.config("Dynamische Menge \"" + set.getName() + "\" um " + addedObjects.length + " Objekte vergr\u00f6ssert");
            systemObjectArray = addedObjects;
            n2 = addedObjects.length;
            n = 0;
            while (n < n2) {
                obj = systemObjectArray[n];
                if (obj.isValid()) {
                    this.initialisiereMeldung(obj);
                }
                ++n;
            }
        }
        if (removedObjects.length > 0) {
            DEBUG.config("Dynamische Menge \"" + set.getName() + "\" um " + removedObjects.length + " Objekte verkleinert");
            systemObjectArray = removedObjects;
            n2 = removedObjects.length;
            n = 0;
            while (n < n2) {
                obj = systemObjectArray[n];
                this.bereinigeMeldung(obj);
                ++n;
            }
        }
    }

    private void bereinigeMeldung(SystemObject obj) {
        TMCVewMeldung meldung = this.aktuelleMeldungen.remove(obj);
        if (meldung != null) {
            meldung.dispose();
        }
    }

    private void bereinigeMeldung(DynamicObject obj) {
        obj.removeListenerForInvalidation((InvalidationListener)this);
        DEBUG.fine("Invalidation-Listener abgemeldet f\u00fcr " + obj.getPid());
        this.bereinigeMeldung((SystemObject)obj);
    }

    private void initialisiereMeldung(SystemObject obj) {
        TMCVewMeldung meldung = new TMCVewMeldung(obj, this);
        this.aktuelleMeldungen.put(obj, meldung);
        if (obj instanceof DynamicObject) {
            ((DynamicObject)obj).addListenerForInvalidation((InvalidationListener)this);
            DEBUG.fine("Invalidation-Listener angemeldet f\u00fcr " + obj.getPid());
        }
    }

    public void invalidObject(DynamicObject dynamicObject) {
        DEBUG.config("Objekt " + dynamicObject + " gel\u00f6scht/invalidiert => wird nicht weiter verwaltet");
        this.bereinigeMeldung(dynamicObject);
    }

    public void update(ResultData[] resultData) {
        ResultData[] resultDataArray = resultData;
        int n = resultData.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData data = resultDataArray[n2];
            Aspect asp = data.getDataDescription().getAspect();
            AttributeGroup atg = data.getDataDescription().getAttributeGroup();
            if (atg.equals(this.datenBeschreibung.getAttributeGroup()) && asp.equals(this.datenBeschreibung.getAspect())) {
                if (data.hasData()) {
                    Data.NumberValue nv = data.getData().getUnscaledValue("RDSMeldungsR\u00fcckhaltung");
                    this.rdsMeldungsRueckhaltung = nv == null ? -1L : nv.longValue();
                    Data.TextValue tv = data.getData().getTextValue("RDSMeldungsAktion");
                    this.rdsMeldungsAktion = tv == null ? null : tv.getText();
                } else {
                    this.rdsMeldungsRueckhaltung = -1L;
                    this.rdsMeldungsAktion = null;
                }
                DEBUG.config("Update Daten " + atg.getPid() + " f\u00fcr " + this.lmsObjekt.getName() + "\nRDSMeldungsR\u00fcckhaltung auf " + this.rdsMeldungsRueckhaltung + "\nRDSMeldungsAktion auf " + this.rdsMeldungsAktion);
            }
            ++n2;
        }
    }

    public long getRDSMeldungsRueckhaltung() {
        return this.rdsMeldungsRueckhaltung;
    }

    public String getRDSMeldungsAktion() {
        return this.rdsMeldungsAktion;
    }
}

