/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.ste.tmcvew.TMCVerwaltung;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;

public class TMCVerwaltungApp
implements StandardApplication {
    private Debug debug;
    private String lmsPid;
    private int loeschVerfahren;
    private int ohneZeitstempelKorrektur;
    private static final String LMS_TYP = "typ.tmcLandesMeldeStelle";
    private ClientDavInterface connection;

    public TMCVerwaltungApp() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ConfigurationObject getKonfigObjekt(String pid, String typ) throws IllegalArgumentException {
        ConfigurationObject obj = null;
        try {
            obj = (ConfigurationObject)this.connection.getDataModel().getObject(pid);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Die PID \"" + pid + "\" bezeichnet kein KonfigurationsObjekt");
        }
        if (obj == null) {
            throw new IllegalArgumentException("Zur PID \"" + pid + "\" wurde kein Konfigurationsobjekt gefunden ");
        }
        if (typ != null && !obj.isOfType(typ)) {
            throw new IllegalArgumentException("Das Konfigurationsobjekt \"" + obj.getPid() + "\" ist nicht vom Typ " + typ);
        }
        return obj;
    }

    public void parseArguments(ArgumentList argumentList) {
        this.debug = Debug.getLogger();
        this.lmsPid = argumentList.fetchArgument("-lms=").asNonEmptyString();
        argumentList.fetchUnusedArguments();
    }

    public void initialize(ClientDavInterface con) {
        this.connection = con;
        try {
            MessageSender.getInstance().setApplicationLabel(this.connection.getLocalApplicationObject().getName());
            ConfigurationObject lmsobjekt = this.getKonfigObjekt(this.lmsPid, LMS_TYP);
            if (lmsobjekt == null) {
                throw new RuntimeException("Das angegebene Objekt '" + this.lmsPid + "' kann nicht vom Datenverteiler gelesen werden!");
            }
            if (!lmsobjekt.isOfType(LMS_TYP)) {
                throw new RuntimeException("Das angegebene Objekt '" + this.lmsPid + "' ist nicht vom Typ '" + LMS_TYP + "'!");
            }
            final TMCVerwaltung verwaltung = new TMCVerwaltung(this.connection, lmsobjekt, this.loeschVerfahren | this.ohneZeitstempelKorrektur);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    TMCVerwaltungApp.this.debug.info("Freigabe Ressourcen ...");
                    verwaltung.dispose();
                }
            });
            this.debug.info("SWE TMC-Meldungsverwaltung initialisiert");
        }
        catch (Exception e) {
            this.debug.error("Abbruch der SWE TMC-Meldungsverwaltung w\u00e4hrend der Initialisierung", (Throwable)e);
            System.exit(1);
        }
    }

    public static void main(String[] arguments) {
        StandardApplicationRunner.run((StandardApplication)new TMCVerwaltungApp(), (String[])arguments);
    }
}

