/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.TMCVerwaltung;
import de.bsvrz.ste.tmcvew.TMCVewSender;
import de.bsvrz.ste.tmcvew.parameter.ParameterEmpfaenger;
import de.bsvrz.ste.tmcvew.parameter.ParameterSender;
import de.bsvrz.sys.funclib.debug.Debug;

public class TMCVewMeldung
implements ClientReceiverInterface {
    private static final Debug DEBUG = Debug.getLogger();
    private SystemObject davObjekt;
    private TMCVerwaltung verwaltung;
    private final DataDescription datenBeschreibungVersendet;
    private final DataDescription datenBeschreibungGeneriert;
    private final DataDescription datenBeschreibungBearbeitet;
    private boolean angemeldet;
    private ResultData datenGeneriert;
    private ResultData datenBearbeitet;
    private TMCVewSender sender;

    public SystemObject getDavObjekt() {
        return this.davObjekt;
    }

    public DataDescription getDatenBeschreibungGeneriert() {
        return this.datenBeschreibungGeneriert;
    }

    public boolean isAngemeldet() {
        return this.angemeldet;
    }

    protected static Quelle getQuelle(Data data) {
        Quelle result = null;
        try {
            Data vewInfo = data.getItem("TMCDaten").getItem("VerwaltungsInformationen");
            Data.TextValue tv = vewInfo.getTextValue("Erzeugungsart");
            return Quelle.get(tv.getText());
        }
        catch (RuntimeException e) {
            DEBUG.warning("Quelle kann nicht bestimmt werden f\u00fcr Datum " + data.getName(), (Throwable)e);
            return result;
        }
    }

    protected static Zustand getZustand(Data data) {
        Zustand result = null;
        try {
            Data vewInfo = data.getItem("TMCDaten").getItem("VerwaltungsInformationen");
            Data.TextValue tv = vewInfo.getTextValue("BearbeitungsZustand");
            return Zustand.get(tv.getText());
        }
        catch (RuntimeException e) {
            DEBUG.warning("Zustand kann nicht bestimmt werden f\u00fcr Datum " + data.getName(), (Throwable)e);
            return result;
        }
    }

    protected static TMCStatus getStatus(Data data) {
        TMCStatus result = null;
        try {
            Data vewInfo = data.getItem("TMCDaten").getItem("VerwaltungsInformationen");
            Data.TextValue tv = vewInfo.getTextValue("TmcStatus");
            return TMCStatus.get(tv.getText());
        }
        catch (RuntimeException e) {
            DEBUG.warning("Status kann nicht bestimmt werden f\u00fcr Datum " + data.getName(), (Throwable)e);
            return result;
        }
    }

    public TMCVewMeldung(SystemObject objekt, TMCVerwaltung verwaltung) {
        this.davObjekt = objekt;
        this.verwaltung = verwaltung;
        AttributeGroup atg = this.getConnection().getDataModel().getAttributeGroup("atg.tmcVerkehrsMeldung");
        Aspect asp = this.getConnection().getDataModel().getAspect("asp.tmcGeneriert");
        this.datenBeschreibungGeneriert = new DataDescription(atg, asp);
        asp = this.getConnection().getDataModel().getAspect("asp.tmcBearbeitet");
        this.datenBeschreibungBearbeitet = new DataDescription(atg, asp);
        asp = this.getConnection().getDataModel().getAspect("asp.tmcVersendet");
        this.datenBeschreibungVersendet = new DataDescription(atg, asp);
        this.sender = new TMCVewSender(this);
        this.datenBearbeitet = new ParameterEmpfaenger(this.getConnection(), this.getDavObjekt(), "atg.tmcVerkehrsMeldung", this.datenBeschreibungBearbeitet).getData();
        this.getConnection().subscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungBearbeitet, ReceiveOptions.normal(), ReceiverRole.drain());
        DEBUG.fine(this.datenBeschreibungBearbeitet + " zum Empfang angemeldet f\u00fcr " + this.davObjekt);
        this.getConnection().subscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungGeneriert, ReceiveOptions.normal(), ReceiverRole.receiver());
        DEBUG.fine(this.datenBeschreibungGeneriert + " zum Empfang angemeldet f\u00fcr " + this.davObjekt);
        this.getConnection().subscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungVersendet, ReceiveOptions.normal(), ReceiverRole.receiver());
        DEBUG.fine(this.datenBeschreibungVersendet + " zum Empfang angemeldet f\u00fcr " + this.davObjekt);
        this.angemeldet = true;
    }

    public void dispose() {
        if (this.isAngemeldet()) {
            this.getConnection().unsubscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungBearbeitet);
            DEBUG.fine("Empfang abgemeldet von " + this.datenBeschreibungBearbeitet + " f\u00fcr " + this.davObjekt);
            this.getConnection().unsubscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungGeneriert);
            DEBUG.fine("Empfang abgemeldet von " + this.datenBeschreibungGeneriert + " f\u00fcr " + this.davObjekt);
            this.getConnection().unsubscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungVersendet);
            DEBUG.fine("Empfang abgemeldet von " + this.datenBeschreibungVersendet + " f\u00fcr " + this.davObjekt);
            this.angemeldet = false;
        }
        if (this.sender != null) {
            this.sender.dispose();
            this.sender = null;
        }
    }

    public ClientDavInterface getConnection() {
        return this.verwaltung.getConnection();
    }

    protected static void setStatus(Data data, TMCStatus status) {
        Data vewInfo = data.getItem("TMCDaten").getItem("VerwaltungsInformationen");
        Data.TextValue tv = vewInfo.getTextValue("TmcStatus");
        tv.setText(status.toString());
    }

    protected void loesche() {
        DEBUG.config("Das Meldungsobjekt '" + this.getDavObjekt() + "' wird gel\u00f6scht");
        MutableSet menge = this.verwaltung.getKonfigObjekt().getMutableSet("TMCMeldungen");
        if (menge != null) {
            try {
                menge.remove(this.getDavObjekt());
            }
            catch (ConfigurationChangeException e) {
                throw new RuntimeException("Objekt " + this.getDavObjekt() + " konnte nicht aus Menge " + menge + "entfernt werden", e);
            }
            try {
                this.getDavObjekt().invalidate();
            }
            catch (ConfigurationChangeException e) {
                throw new RuntimeException("Objekt " + this.getDavObjekt() + " konnte nicht gel\u00f6scht werden", e);
            }
        }
        throw new IllegalStateException("Dynamische Menge \"TMCMeldungen\" nicht gefunden f\u00fcr " + this.verwaltung.getKonfigObjekt());
    }

    public void update(ResultData[] resultData) {
        ResultData[] resultDataArray = resultData;
        int n = resultData.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData data = resultDataArray[n2];
            Aspect asp = data.getDataDescription().getAspect();
            AttributeGroup atg = data.getDataDescription().getAttributeGroup();
            if (atg.equals(this.datenBeschreibungGeneriert.getAttributeGroup()) && asp.equals(this.datenBeschreibungGeneriert.getAspect())) {
                if (this.angemeldet) {
                    DEBUG.fine("Update f\u00fcr " + data.getObject() + " mit " + data.getDataDescription());
                    this.datenGeneriert = data;
                    this.bearbeiteDaten(data);
                } else {
                    DEBUG.warning("Update nicht erwartet, da Datenbeschreibung f\u00fcr dieses Objekt bereits abgemeldet oder nicht angemeldet: \tAktuelle Zeit    : " + this.getConnection().getTime() + "\tZeitstempel      : " + data.getDataTime() + "\tObjekt           : " + data.getObject() + "\tDatenbeschreibung: " + data.getDataDescription());
                }
            }
            if (atg.equals(this.datenBeschreibungVersendet.getAttributeGroup()) && asp.equals(this.datenBeschreibungVersendet.getAspect())) {
                if (this.angemeldet) {
                    DEBUG.fine("Update f\u00fcr " + data.getObject() + " mit " + data.getDataDescription());
                    if (data.hasData()) {
                        Data datenSatz = data.getData().createModifiableCopy();
                        long zeitStempel = data.getDataTime();
                        Quelle quelle = TMCVewMeldung.getQuelle(datenSatz);
                        Zustand zustand = TMCVewMeldung.getZustand(datenSatz);
                        TMCStatus status = TMCVewMeldung.getStatus(datenSatz);
                        DEBUG.fine("Bearbeite empfangene Daten f\u00fcr " + this.getDavObjekt().getPid() + " Aspekt: " + asp.getName() + " Quelle: " + (Object)((Object)quelle) + " Zustand: " + (Object)((Object)zustand) + " Status: " + (Object)((Object)status) + " ZeitStempel: " + zeitStempel);
                        if (status == TMCStatus.Geloescht) {
                            this.loesche();
                        }
                    }
                } else {
                    DEBUG.warning("Update nicht erwartet, da Datenbeschreibung f\u00fcr dieses Objekt bereits abgemeldet oder nicht angemeldet: \tAktuelle Zeit    : " + this.getConnection().getTime() + "\tZeitstempel      : " + data.getDataTime() + "\tObjekt           : " + data.getObject() + "\tDatenbeschreibung: " + data.getDataDescription());
                }
            }
            if (atg.equals(this.datenBeschreibungBearbeitet.getAttributeGroup()) && asp.equals(this.datenBeschreibungBearbeitet.getAspect())) {
                if (this.angemeldet) {
                    DEBUG.fine("Update f\u00fcr " + data.getObject() + " mit " + data.getDataDescription());
                    this.datenBearbeitet = data;
                    this.bearbeiteDaten(data);
                    if (data.hasData()) {
                        new ParameterSender(this.getConnection(), this.getDavObjekt(), data, "atg.tmcVerkehrsMeldung").start();
                    }
                } else {
                    DEBUG.warning("Update nicht erwartet, da Datenbeschreibung f\u00fcr dieses Objekt bereits abgemeldet oder nicht angemeldet: \tAktuelle Zeit    : " + this.getConnection().getTime() + "\tZeitstempel      : " + data.getDataTime() + "\tObjekt           : " + data.getObject() + "\tDatenbeschreibung: " + data.getDataDescription());
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bearbeiteDaten(ResultData data) {
        TMCStatus sendeStatus;
        Data datenSenden;
        if (!data.hasData()) {
            return;
        }
        Aspect asp = data.getDataDescription().getAspect();
        Data datenSatz = data.getData().createModifiableCopy();
        long zeitStempel = data.getDataTime();
        Quelle quelle = TMCVewMeldung.getQuelle(datenSatz);
        Zustand zustand = TMCVewMeldung.getZustand(datenSatz);
        TMCStatus status = TMCVewMeldung.getStatus(datenSatz);
        boolean loeschen = false;
        String text = "Bearbeite empfangene Daten f\u00fcr " + this.getDavObjekt().getPid() + "\nAspekt: " + asp.getName() + "\nQuelle: " + (Object)((Object)quelle) + "\nZustand: " + (Object)((Object)zustand) + "\nStatus: " + (Object)((Object)status) + "\nZeitStempel: " + zeitStempel;
        String suffixFehler = "\nEmpfangene Daten werden NICHT weitergeleitet";
        if (asp.equals(this.datenBeschreibungGeneriert.getAspect())) {
            if (quelle != Quelle.Automatisch) {
                DEBUG.error(String.valueOf(text) + "\nFEHLER: Quelle " + (Object)((Object)quelle) + " - f\u00fcr Aspekt " + asp.getName() + " ist nur " + (Object)((Object)Quelle.Automatisch) + " zul\u00e4ssig" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
            if (zustand != Zustand.NichtQuittiert) {
                DEBUG.error(String.valueOf(text) + "\nFEHLER: Zustand " + (Object)((Object)zustand) + " - f\u00fcr Quelle " + (Object)((Object)quelle) + "/" + asp.getPid() + " ist nur " + (Object)((Object)Zustand.NichtQuittiert) + " zul\u00e4ssig" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
        } else if (asp.equals(this.datenBeschreibungBearbeitet.getAspect())) {
            if (quelle == Quelle.Automatisch) {
                if (zustand != Zustand.Quittiert && zustand != Zustand.Editiert && zustand != Zustand.Verworfen) {
                    DEBUG.error(String.valueOf(text) + "\nFEHLER: Zustand " + (Object)((Object)zustand) + " - f\u00fcr Quelle " + (Object)((Object)quelle) + "/" + asp.getPid() + " sind nur " + (Object)((Object)Zustand.Quittiert) + ", " + (Object)((Object)Zustand.Editiert) + " und " + (Object)((Object)Zustand.Verworfen) + " zul\u00e4ssig" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                    return;
                }
            } else {
                if (quelle != Quelle.Manuell) {
                    DEBUG.error(String.valueOf(text) + "\nFEHLER: Quelle " + (Object)((Object)quelle) + " - f\u00fcr Aspekt " + asp.getName() + " sind nur " + (Object)((Object)Quelle.Automatisch) + " und " + (Object)((Object)Quelle.Manuell) + " zul\u00e4ssig" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                    return;
                }
                if (zustand != Zustand.Editiert && zustand != Zustand.Verworfen) {
                    DEBUG.error(String.valueOf(text) + "\nFEHLER: Zustand " + (Object)((Object)zustand) + " - f\u00fcr Quelle " + (Object)((Object)quelle) + "/" + asp.getPid() + " sind nur " + (Object)((Object)Zustand.Editiert) + " und " + (Object)((Object)Zustand.Verworfen) + " zul\u00e4ssig" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                    return;
                }
            }
        }
        if (asp.equals(this.datenBeschreibungGeneriert.getAspect())) {
            if (this.datenBearbeitet != null && this.datenBearbeitet.hasData() && this.datenBearbeitet.getDataTime() > zeitStempel) {
                DEBUG.warning(String.valueOf(text) + "\nEs liegen bereits bearbeite Daten mit h\u00f6herem Zeitstempel " + this.datenBearbeitet.getDataTime() + " vor" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
            if (this.sender.getDatenSenden() != null && this.sender.getDatenSenden().hasData() && this.sender.getDatenSenden().getDataTime() > zeitStempel) {
                DEBUG.warning(String.valueOf(text) + "\nEs liegen bereits gesendete Daten mit h\u00f6herem Zeitstempel " + this.sender.getDatenSenden().getDataTime() + " vor" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
        }
        if (asp.equals(this.datenBeschreibungBearbeitet.getAspect())) {
            if (zustand == Zustand.Quittiert && this.datenGeneriert != null && this.datenGeneriert.hasData() && this.datenGeneriert.getDataTime() > zeitStempel) {
                DEBUG.warning(String.valueOf(text) + "\nEs liegen bereits generierte Daten mit h\u00f6herem Zeitstempel " + this.datenGeneriert.getDataTime() + " vor" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
            if (this.sender.getDatenSenden() != null && this.sender.getDatenSenden().hasData() && this.sender.getDatenSenden().getDataTime() > zeitStempel) {
                DEBUG.warning(String.valueOf(text) + "\nEs liegen bereits gesendete Daten mit h\u00f6herem Zeitstempel " + this.sender.getDatenSenden().getDataTime() + " vor" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
        }
        Data data2 = datenSenden = this.sender.getDatenSenden() != null && this.sender.getDatenSenden().hasData() ? this.sender.getDatenSenden().getData() : null;
        if (datenSenden != null && (sendeStatus = TMCVewMeldung.getStatus(datenSenden)) == TMCStatus.Geloescht) {
            DEBUG.config(String.valueOf(text) + "\nEs liegt bereits eine Aktualisierung mit Status " + (Object)((Object)sendeStatus) + " vor" + "\nEmpfangene Daten werden NICHT weitergeleitet");
            return;
        }
        if (asp.equals(this.datenBeschreibungGeneriert.getAspect())) {
            Zustand zustandBearbeitet;
            Data datenBearbeitetData = this.datenBearbeitet != null && this.datenBearbeitet.hasData() ? this.datenBearbeitet.getData() : null;
            Zustand zustand2 = zustandBearbeitet = datenBearbeitetData != null ? TMCVewMeldung.getZustand(datenBearbeitetData) : null;
            if (zustandBearbeitet == Zustand.Editiert || zustandBearbeitet == Zustand.Verworfen) {
                DEBUG.config(String.valueOf(text) + "\nEs liegen bearbeitete Daten im Zustand " + (Object)((Object)zustandBearbeitet) + " vor" + "\nEmpfangene Daten werden NICHT weitergeleitet");
                return;
            }
        }
        if (asp.equals(this.datenBeschreibungBearbeitet.getAspect()) && zustand == Zustand.Verworfen && status != TMCStatus.Geloescht) {
            text = String.valueOf(text) + "\nDer Status wird auf \"" + TMCStatus.Geloescht.toString() + "\" gesetzt, da der Zustand \"" + (Object)((Object)Zustand.Verworfen) + "\" ist";
            try {
                TMCVewMeldung.setStatus(datenSatz, TMCStatus.Geloescht);
            }
            catch (RuntimeException e) {
                DEBUG.error(String.valueOf(text) + "\nFehler beim Setzen von Status auf " + (Object)((Object)TMCStatus.Geloescht) + "\nEmpfangene Daten werden NICHT weitergeleitet", (Throwable)e);
                return;
            }
        }
        if (loeschen) {
            DEBUG.config(String.valueOf(text) + "\nEmpfangene Daten werden NICHT weitergeleitet" + "\nAktuelle Meldung wird gel\u00f6scht");
            try {
                this.loesche();
                return;
            }
            catch (RuntimeException e) {
                DEBUG.error("Fehler beim L\u00f6schen von " + this.getDavObjekt(), (Throwable)e);
                return;
            }
        }
        if (asp.equals(this.datenBeschreibungGeneriert.getAspect())) {
            long verzoegerung = this.getRDSMeldungsRueckhaltung() * 1000L;
            text = String.valueOf(text) + "\nEmpfangene generierte Daten werden zur Weiterleitung gem\u00e4\u00df RDSMeldungsAktion in " + Math.round(verzoegerung / 1000L) + "s freigegeben";
            DEBUG.config(text);
            this.sender.starteSenden(datenSatz, zeitStempel, verzoegerung, true, asp);
            return;
        }
        if (!asp.equals(this.datenBeschreibungBearbeitet.getAspect())) return;
        text = String.valueOf(text) + "\nEmpfangene bearbeitete Daten werden zur sofortigen Weiterleitung freigegeben";
        DEBUG.config(text);
        this.sender.starteSenden(datenSatz, zeitStempel, 0L, true, asp);
    }

    public long getRDSMeldungsRueckhaltung() {
        return this.verwaltung.getRDSMeldungsRueckhaltung();
    }

    public String getRDSMeldungsAktion() {
        return this.verwaltung.getRDSMeldungsAktion();
    }

    public static enum Quelle {
        Manuell,
        Automatisch,
        LMS;


        public String toString() {
            switch (this) {
                case Manuell: {
                    return "manuell";
                }
                case Automatisch: {
                    return "automatisch";
                }
                case LMS: {
                    return "LMS";
                }
            }
            return super.toString();
        }

        public static Quelle get(String text) {
            Quelle[] quelleArray = Quelle.values();
            int n = quelleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Quelle quelle = quelleArray[n2];
                if (text.equals(quelle.toString())) {
                    return quelle;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.valueOf(text) + " ist kein Text zu enum Quelle");
        }
    }

    public static enum TMCStatus {
        Unbekannt("Unbekannt", -1),
        Neu("Neu", 1),
        Geaendert("Ge\u00e4ndert", 2),
        Geloescht("Gel\u00f6scht", 3);

        private final String value;
        private int id;

        private TMCStatus(String value, int id) {
            this.value = value;
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public static TMCStatus get(String text) {
            TMCStatus[] tMCStatusArray = TMCStatus.values();
            int n = tMCStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                TMCStatus status = tMCStatusArray[n2];
                if (text.equals(status.toString())) {
                    return status;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.valueOf(text) + " ist kein Text zu enum Status");
        }
    }

    public static enum Zustand {
        NichtQuittiert,
        Quittiert,
        Editiert,
        Verworfen;


        public String toString() {
            switch (this) {
                case NichtQuittiert: {
                    return "nicht quittiert";
                }
                case Quittiert: {
                    return "quittiert";
                }
                case Editiert: {
                    return "editiert";
                }
                case Verworfen: {
                    return "verworfen";
                }
            }
            return super.toString();
        }

        public static Zustand get(String text) {
            Zustand[] zustandArray = Zustand.values();
            int n = zustandArray.length;
            int n2 = 0;
            while (n2 < n) {
                Zustand zustand = zustandArray[n2];
                if (text.equals(zustand.toString())) {
                    return zustand;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.valueOf(text) + " ist kein Text zu enum Zustand");
        }
    }
}

