/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.TMCVewMeldung;
import de.bsvrz.sys.funclib.debug.Debug;

public class TMCVewSender
implements ClientSenderInterface {
    private static final Debug DEBUG = Debug.getLogger();
    private boolean warten;
    public static final SenderRole ROLLE = SenderRole.source();
    public static final long SENDE_TIMEOUT = 5000L;
    private boolean angemeldet;
    private final DataDescription datenBeschreibung;
    private final TMCVewMeldung meldung;
    private ResultData datenSenden;
    private SendeThread sendeThread;

    public boolean isAngemeldet() {
        return this.angemeldet;
    }

    public ClientDavInterface getConnection() {
        return this.meldung.getConnection();
    }

    public SystemObject getDavObjekt() {
        return this.meldung.getDavObjekt();
    }

    public TMCVewSender(TMCVewMeldung meldung) {
        this.meldung = meldung;
        AttributeGroup atg = this.getConnection().getDataModel().getAttributeGroup("atg.tmcVerkehrsMeldung");
        Aspect asp = this.getConnection().getDataModel().getAspect("asp.tmcSenden");
        this.datenBeschreibung = new DataDescription(atg, asp);
        try {
            this.getConnection().subscribeSender((ClientSenderInterface)this, this.getDavObjekt(), this.datenBeschreibung, ROLLE);
            DEBUG.fine(this.datenBeschreibung + " zum Senden angemeldet f\u00fcr " + this.getDavObjekt());
        }
        catch (OneSubscriptionPerSendData e) {
            DEBUG.warning(String.valueOf(meldung.getDavObjekt().getPid()) + " ist bereits an anderer Stelle zum Senden angemeldet", (Throwable)e);
            return;
        }
        this.angemeldet = true;
    }

    public void dispose() {
        this.stopSenden();
        if (this.angemeldet) {
            this.getConnection().unsubscribeSender((ClientSenderInterface)this, this.getDavObjekt(), this.datenBeschreibung);
            DEBUG.fine("Senden abgemeldet von " + this.datenBeschreibung + " f\u00fcr " + this.getDavObjekt());
            this.angemeldet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(ResultData resultData) {
        try {
            this.getConnection().sendData(resultData);
        }
        catch (SendSubscriptionNotConfirmed e) {
            DEBUG.fine("Warte max. 5000ms auf Sendesteuerung f\u00fcr " + this.getDavObjekt().getPid());
            TMCVewSender tMCVewSender = this;
            synchronized (tMCVewSender) {
                this.warten = true;
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.warten = false;
            }
            try {
                this.getConnection().sendData(resultData);
            }
            catch (SendSubscriptionNotConfirmed ex) {
                DEBUG.warning("Keine Sendesteuerung f\u00fcr " + this.getDavObjekt().getPid(), (Throwable)ex);
                return false;
            }
            return true;
        }
        catch (DataNotSubscribedException e) {
            DEBUG.error("Keine Sendeanmeldung bzw. Sendeanmeldung ung\u00fcltig f\u00fcr " + this.getDavObjekt().getPid(), (Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        DEBUG.fine("dataRequest() f\u00fcr " + this.getDavObjekt().getPid() + " - Sender state: " + state);
        if (this.warten && state == 0) {
            TMCVewSender tMCVewSender = this;
            synchronized (tMCVewSender) {
                this.notify();
            }
        }
    }

    public boolean isRequestSupported(SystemObject so, DataDescription dd) {
        return true;
    }

    public ResultData getDatenSenden() {
        return this.datenSenden;
    }

    void setDatenSenden(ResultData datenSenden) {
        this.datenSenden = datenSenden;
    }

    SendeThread getSendeThread() {
        return this.sendeThread;
    }

    void setSendeThread(SendeThread sendeThread) {
        this.sendeThread = sendeThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void starteSenden(Data data, long zeitStempel, long verzoegerung, boolean bedingterAbbruch, Aspect empfangsAspekt) {
        if (bedingterAbbruch && this.sendeThread != null && this.sendeThread.empfangsAspekt.equals(this.meldung.getDatenBeschreibungGeneriert().getAspect())) {
            this.stopSenden();
            DEBUG.fine("Laufenden Sende-Auftrag abgebrochen f\u00fcr " + this.getDavObjekt().getPid());
        }
        TMCVewSender tMCVewSender = this;
        synchronized (tMCVewSender) {
            this.sendeThread = new SendeThread(data, zeitStempel, verzoegerung, empfangsAspekt);
            this.sendeThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSenden() {
        TMCVewSender tMCVewSender = this;
        synchronized (tMCVewSender) {
            if (this.sendeThread != null) {
                this.sendeThread.abbrechen();
            }
        }
    }

    class SendeThread
    extends Thread {
        private final long verzoegerung;
        private final Data data;
        private final long zeitStempel;
        private final Aspect empfangsAspekt;
        private boolean abgebrochen;

        boolean isAbgebrochen() {
            return this.abgebrochen;
        }

        SendeThread(Data data, long zeitStempel, long verzoegerung, Aspect empfangsAspekt) {
            this.data = data;
            this.zeitStempel = zeitStempel;
            this.verzoegerung = verzoegerung;
            this.empfangsAspekt = empfangsAspekt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void abbrechen() {
            SendeThread sendeThread = this;
            synchronized (sendeThread) {
                this.interrupt();
                this.abgebrochen = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.isAbgebrochen() && this.verzoegerung > 0L) {
                TMCVewSender.this.getConnection().sleep(this.verzoegerung);
            }
            TMCVewSender tMCVewSender = TMCVewSender.this;
            synchronized (tMCVewSender) {
                try {
                    if (!this.isAbgebrochen()) {
                        String text = "Daten mit Zeitstempel " + this.zeitStempel + " empfangen unter dem Aspekt " + this.empfangsAspekt.getName();
                        if (this.empfangsAspekt.equals(TMCVewSender.this.meldung.getDatenBeschreibungGeneriert().getAspect()) && TMCVewMeldung.getQuelle(this.data) == TMCVewMeldung.Quelle.Automatisch && TMCVewMeldung.getZustand(this.data) == TMCVewMeldung.Zustand.NichtQuittiert && TMCVewSender.this.meldung.getRDSMeldungsAktion().equals("0")) {
                            DEBUG.fine(String.valueOf(text) + " werden NICHT unter dem Aspekt " + TMCVewSender.this.datenBeschreibung.getAspect().getName() + " gesendet, da RDSMeldungsAktion den Wert \"" + TMCVewSender.this.meldung.getRDSMeldungsAktion() + "\" hat");
                            return;
                        }
                        ResultData resultData = new ResultData(TMCVewSender.this.getDavObjekt(), TMCVewSender.this.datenBeschreibung, this.zeitStempel, this.data);
                        if (TMCVewSender.this.send(resultData)) {
                            DEBUG.fine(String.valueOf(text) + " wurden erfolgreich unter dem Aspekt " + TMCVewSender.this.datenBeschreibung.getAspect().getName() + " gesendet");
                            TMCVewSender.this.setDatenSenden(resultData);
                        }
                    }
                }
                finally {
                    if (TMCVewSender.this.getSendeThread() == this) {
                        TMCVewSender.this.setSendeThread(null);
                    }
                }
            }
        }
    }
}

