/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew.parameter;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.config.DoubleAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.ReferenceAttributeType;
import de.bsvrz.dav.daf.main.config.StringAttributeType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.TimeAttributeType;

public final class DatenTools {
    private DatenTools() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void tiefeKopie(Data quelle, Data ziel) {
        if (quelle.getAttributeType() == null && ziel.getAttributeType() != null || quelle.getAttributeType() != null && ziel.getAttributeType() == null || quelle.getAttributeType() != null && ziel.getAttributeType() != null && !quelle.getAttributeType().equals(ziel.getAttributeType())) {
            throw new IllegalArgumentException("Attributtypen des Datums \"" + quelle.getName() + "\" sind nicht gleich f\u00fcr Quelle und Ziel");
        }
        if (quelle.getAttributeType() != null && ziel.getAttributeType() != null && !quelle.getName().equals(ziel.getName())) {
            throw new IllegalArgumentException("Attributnamen des Datums \"" + quelle.getName() + "\" sind nicht gleich f\u00fcr Quelle und Ziel");
        }
        if (quelle.isList()) {
            for (Data subQuelle : quelle) {
                Data subZiel = ziel.getItem(subQuelle.getName());
                if (subZiel == null) {
                    throw new IllegalArgumentException("Ziel-Datensatz hat kein Sub-Datum \"" + subQuelle.getName() + "\"");
                }
                DatenTools.tiefeKopie(subQuelle, subZiel);
            }
            return;
        } else if (quelle.isArray()) {
            Data.Array arrQuelle = quelle.asArray();
            Data.Array arrZiel = ziel.asArray();
            arrZiel.setLength(arrQuelle.getLength());
            int i = 0;
            while (i < arrQuelle.getLength()) {
                Data subSource = arrQuelle.getItem(i);
                Data subTarget = arrZiel.getItem(i);
                DatenTools.tiefeKopie(subSource, subTarget);
                ++i;
            }
            return;
        } else {
            if (!quelle.isPlain()) throw new UnsupportedOperationException("Operation nur f\u00fcr Attributlisten, Arrays und einfache Datentypen definiert");
            if (quelle.getAttributeType() instanceof StringAttributeType) {
                String value = quelle.asTextValue().getText();
                ziel.asTextValue().setText(value);
                return;
            } else if (quelle.getAttributeType() instanceof IntegerAttributeType) {
                long value = quelle.asUnscaledValue().longValue();
                ziel.asUnscaledValue().set(value);
                return;
            } else if (quelle.getAttributeType() instanceof DoubleAttributeType) {
                double value = quelle.asScaledValue().doubleValue();
                ziel.asScaledValue().set(value);
                return;
            } else if (quelle.getAttributeType() instanceof TimeAttributeType) {
                long value = quelle.asTimeValue().getMillis();
                ziel.asTimeValue().setMillis(value);
                return;
            } else {
                if (!(quelle.getAttributeType() instanceof ReferenceAttributeType)) throw new UnsupportedOperationException("Operation nicht definiert f\u00fcr Datum \"" + quelle.getName() + "\" und Attributtyp" + quelle.getAttributeType());
                SystemObject value = quelle.asReferenceValue().getSystemObject();
                ziel.asReferenceValue().setSystemObject(value);
            }
        }
    }
}

