/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew.parameter;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.parameter.DatenTools;
import de.bsvrz.sys.funclib.debug.Debug;

public class ParameterEmpfaenger
implements ClientReceiverInterface {
    private static final Debug DEBUG = Debug.getLogger();
    static final long TIMEOUT = 5000L;
    private final ClientDavInterface connection;
    private final SystemObject davObjekt;
    private final DataDescription datenBeschreibungQuell;
    private final DataDescription datenBeschreibungZiel;
    private boolean warten;
    private ResultData davData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParameterEmpfaenger(ClientDavInterface con, SystemObject obj, String atgQuellPid, DataDescription datenBeschreibungZiel) {
        this.connection = con;
        this.davObjekt = obj;
        AttributeGroup atg = this.connection.getDataModel().getAttributeGroup(atgQuellPid);
        Aspect asp = this.connection.getDataModel().getAspect("asp.parameterSoll");
        this.datenBeschreibungQuell = new DataDescription(atg, asp);
        this.datenBeschreibungZiel = datenBeschreibungZiel;
        this.connection.subscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungQuell, ReceiveOptions.normal(), ReceiverRole.receiver());
        DEBUG.finest(this.datenBeschreibungQuell + " zum Empfang angemeldet f\u00fcr " + this.davObjekt);
        DEBUG.finer("Warte max. 5000ms auf Update Parameter-Daten von " + atg.getPid() + " f\u00fcr " + this.davObjekt.getPid());
        ParameterEmpfaenger parameterEmpfaenger = this;
        synchronized (parameterEmpfaenger) {
            if (this.getData() == null) {
                this.warten = true;
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.warten = false;
            }
        }
        if (this.getData() == null) {
            DEBUG.warning("Keine Parameter-Daten empfangen von " + atg.getPid() + " f\u00fcr " + this.davObjekt.getPid());
        }
        this.connection.unsubscribeReceiver((ClientReceiverInterface)this, this.davObjekt, this.datenBeschreibungQuell);
        DEBUG.finest("Empfang abgemeldet von " + this.datenBeschreibungQuell + " f\u00fcr " + this.davObjekt);
    }

    public ResultData getData() {
        return this.davData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResultData[] resultData) {
        ResultData[] resultDataArray = resultData;
        int n = resultData.length;
        int n2 = 0;
        while (n2 < n) {
            ResultData data = resultDataArray[n2];
            Aspect asp = data.getDataDescription().getAspect();
            AttributeGroup atg = data.getDataDescription().getAttributeGroup();
            if (atg.equals(this.datenBeschreibungQuell.getAttributeGroup()) && asp.equals(this.datenBeschreibungQuell.getAspect())) {
                if (data.hasData()) {
                    Data datenSatz = this.connection.createData(this.datenBeschreibungZiel.getAttributeGroup());
                    DatenTools.tiefeKopie(data.getData(), datenSatz);
                    this.davData = new ResultData(this.davObjekt, this.datenBeschreibungZiel, data.getDataTime(), datenSatz);
                    DEBUG.fine("Bestehende Parameter-Daten empfangen von " + atg.getPid() + " f\u00fcr " + this.davObjekt.getPid());
                } else {
                    this.davData = new ResultData(this.davObjekt, this.datenBeschreibungZiel, data.getDataTime(), null);
                }
            }
            ++n2;
        }
        if (this.warten) {
            ParameterEmpfaenger parameterEmpfaenger = this;
            synchronized (parameterEmpfaenger) {
                this.notify();
            }
        }
    }
}

