/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew.parameter;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.parameter.DatenTools;
import de.bsvrz.sys.funclib.debug.Debug;

public class ParameterSender
extends Thread
implements ClientSenderInterface {
    private static final Debug DEBUG = Debug.getLogger();
    static final long TIMEOUT = 5000L;
    private final ClientDavInterface connection;
    private final SystemObject davObjekt;
    private final DataDescription datenBeschreibung;
    private final ResultData daten;
    private boolean warten;

    public ParameterSender(ClientDavInterface con, SystemObject obj, ResultData data, String atgPid) {
        this.connection = con;
        this.davObjekt = obj;
        AttributeGroup atg = this.connection.getDataModel().getAttributeGroup(atgPid);
        Aspect asp = this.connection.getDataModel().getAspect("asp.parameterVorgabe");
        this.datenBeschreibung = new DataDescription(atg, asp);
        Data datenSatz = this.connection.createData(atg);
        DatenTools.tiefeKopie(data.getData(), datenSatz);
        this.daten = new ResultData(this.davObjekt, this.datenBeschreibung, data.getDataTime(), datenSatz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean angemeldet = false;
        try {
            try {
                this.connection.subscribeSender((ClientSenderInterface)this, this.davObjekt, this.datenBeschreibung, SenderRole.sender());
                angemeldet = true;
            }
            catch (OneSubscriptionPerSendData oneSubscriptionPerSendData) {
                // empty catch block
            }
            try {
                this.connection.sendData(this.daten);
                DEBUG.finer("Parameter erfolgreich aktualisiert mit " + this.datenBeschreibung.getAttributeGroup() + " f\u00fcr " + this.davObjekt);
            }
            catch (SendSubscriptionNotConfirmed e) {
                DEBUG.finer("Warte max. 5000ms auf Sendesteuerung f\u00fcr " + this.davObjekt.getPid());
                ParameterSender parameterSender = this;
                synchronized (parameterSender) {
                    this.warten = true;
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.warten = false;
                }
                try {
                    this.connection.sendData(this.daten);
                }
                catch (SendSubscriptionNotConfirmed ex) {
                    DEBUG.warning("Keine Sendesteuerung f\u00fcr " + this.davObjekt.getPid(), (Throwable)ex);
                }
            }
            catch (DataNotSubscribedException e) {
                DEBUG.error("Keine Sendeanmeldung bzw. Sendeanmeldung ung\u00fcltig f\u00fcr " + this.davObjekt.getPid(), (Throwable)e);
            }
        }
        finally {
            if (angemeldet) {
                this.connection.unsubscribeSender((ClientSenderInterface)this, this.davObjekt, this.datenBeschreibung);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        DEBUG.finest("dataRequest() f\u00fcr " + this.davObjekt.getPid() + " - Sender state: " + state);
        if (this.warten && state == 0) {
            ParameterSender parameterSender = this;
            synchronized (parameterSender) {
                this.notify();
            }
        }
    }

    public boolean isRequestSupported(SystemObject so, DataDescription dd) {
        return true;
    }
}

