/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;

public class Meldung
implements ClientSenderInterface {
    private static final Debug DEBUG = Debug.getLogger();
    private boolean warten;
    public static final SenderRole QUELLE = SenderRole.source();
    public static final SenderRole SENDER = SenderRole.sender();
    public static final long SENDE_TIMEOUT = 5000L;
    private boolean angemeldet;
    protected final DataDescription _datenBeschreibung;
    private ClientDavInterface connection;
    private SystemObject davObjekt;
    private ResultData _datenSenden = null;

    public boolean isAngemeldet() {
        return this.angemeldet;
    }

    public ClientDavInterface getConnection() {
        return this.connection;
    }

    public SystemObject getDavObjekt() {
        return this.davObjekt;
    }

    public Meldung(ClientDavInterface connection, SystemObject davObjekt, String aspekt) {
        this.connection = connection;
        this.davObjekt = davObjekt;
        String text = null;
        AttributeGroup atg = this.getConnection().getDataModel().getAttributeGroup("atg.tmcVerkehrsMeldung");
        if ("generiert".equalsIgnoreCase(aspekt)) {
            text = "asp.tmcGeneriert";
        }
        if ("bearbeitet".equalsIgnoreCase(aspekt)) {
            text = "asp.tmcBearbeitet";
        }
        if ("versendet".equalsIgnoreCase(aspekt)) {
            text = "asp.tmcVersendet";
        }
        Aspect asp = this.getConnection().getDataModel().getAspect(text);
        this._datenBeschreibung = new DataDescription(atg, asp);
        try {
            if ("generiert".equalsIgnoreCase(aspekt) || "versendet".equalsIgnoreCase(aspekt)) {
                this.getConnection().subscribeSender((ClientSenderInterface)this, this.getDavObjekt(), this._datenBeschreibung, QUELLE);
            } else {
                this.getConnection().subscribeSender((ClientSenderInterface)this, this.getDavObjekt(), this._datenBeschreibung, SENDER);
            }
            this.angemeldet = true;
        }
        catch (OneSubscriptionPerSendData oneSubscriptionPerSendData) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.angemeldet) {
            this.getConnection().unsubscribeSender((ClientSenderInterface)this, this.getDavObjekt(), this._datenBeschreibung);
            DEBUG.config("Senden abgemeldet von " + this._datenBeschreibung + " f\u00fcr " + this.getDavObjekt());
            this.angemeldet = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean send(ResultData resultData) {
        try {
            this.getConnection().sendData(resultData);
        }
        catch (SendSubscriptionNotConfirmed e) {
            System.out.println("Warte max. 5000ms auf Sendesteuerung f\u00fcr " + this.getDavObjekt().getPid());
            Meldung meldung = this;
            synchronized (meldung) {
                this.warten = true;
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.warten = false;
            }
            try {
                this.getConnection().sendData(resultData);
            }
            catch (SendSubscriptionNotConfirmed ex) {
                System.out.println("FEHLER: " + (Object)((Object)ex) + "\nKeine Sendesteuerung f\u00fcr " + this.getDavObjekt().getPid() + " mit " + this._datenBeschreibung);
                return false;
            }
            return true;
        }
        catch (DataNotSubscribedException e) {
            System.out.println("FEHLER: " + (Object)((Object)e) + "\nKeine Sendeanmeldung bzw. Sendeanmeldung ung\u00fcltig f\u00fcr " + this.getDavObjekt().getPid() + " mit " + this._datenBeschreibung);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        DEBUG.config("dataRequest() f\u00fcr " + this.getDavObjekt().getPid() + " - Sender state: " + state);
        if (this.warten && state == 0) {
            Meldung meldung = this;
            synchronized (meldung) {
                this.notify();
            }
        }
    }

    public boolean isRequestSupported(SystemObject so, DataDescription dd) {
        return true;
    }

    public ResultData getDatenSenden() {
        return this._datenSenden;
    }

    void setDatenSenden(ResultData datenSenden) {
        this._datenSenden = datenSenden;
    }

    public ResultData getResultData(String quelle, String zustand, String aspekt, String status) {
        String text = null;
        Data data = this.getData(quelle, zustand, status);
        AttributeGroup atg = this.getConnection().getDataModel().getAttributeGroup("atg.tmcVerkehrsMeldung");
        if (aspekt.equalsIgnoreCase("generiert")) {
            text = "asp.tmcGeneriert";
        }
        if (aspekt.equalsIgnoreCase("bearbeitet")) {
            text = "asp.tmcBearbeitet";
        }
        if (aspekt.equalsIgnoreCase("versendet")) {
            text = "asp.tmcVersendet";
        }
        Aspect asp = this.getConnection().getDataModel().getAspect(text);
        return new ResultData(this.getDavObjekt(), new DataDescription(atg, asp), this.getConnection().getTime(), data);
    }

    private Data getData(String quelle, String zustand, String status) {
        AttributeGroup atg = this.getConnection().getDataModel().getAttributeGroup("atg.tmcVerkehrsMeldung");
        Data data = this.getConnection().createData(atg);
        Data item = data.getItem("TMCID");
        item.getTextValue("Datenproduzent").setText("");
        item.getTextValue("Datenkennung").setText("");
        data.getTextValue("Beschreibung").setText("");
        item = data.getItem("TMCDaten");
        Data vi = item.getItem("VerwaltungsInformationen");
        if ("0".equalsIgnoreCase(status)) {
            vi.getItem("TmcStatus").asTextValue().setText("Ge\u00e4ndert");
        }
        if ("1".equalsIgnoreCase(status)) {
            vi.getItem("TmcStatus").asTextValue().setText("Gel\u00f6scht");
        }
        if ("9".equalsIgnoreCase(status)) {
            vi.getItem("TmcStatus").asTextValue().setText("Gel\u00f6scht");
        }
        if ("nicht quittiert".equalsIgnoreCase(zustand)) {
            vi.getItem("BearbeitungsZustand").asTextValue().setText("nicht quittiert");
        }
        if ("quittiert".equalsIgnoreCase(zustand)) {
            vi.getItem("BearbeitungsZustand").asTextValue().setText("quittiert");
        }
        if ("editiert".equalsIgnoreCase(zustand)) {
            vi.getItem("BearbeitungsZustand").asTextValue().setText("editiert");
        }
        if ("verworfen".equalsIgnoreCase(zustand)) {
            vi.getItem("BearbeitungsZustand").asTextValue().setText("verworfen");
        }
        if ("Automatik".equalsIgnoreCase(quelle)) {
            vi.getItem("Erzeugungsart").asTextValue().setText("automatisch");
        }
        if ("Manuell".equalsIgnoreCase(quelle)) {
            vi.getItem("Erzeugungsart").asTextValue().setText("manuell");
        }
        return data;
    }
}

