/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.INeueDatenListener;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class RdsMeldungsEmpfang
implements ClientReceiverInterface {
    private boolean _debugAnmelde = false;
    private Debug debug;
    private boolean _debug = false;
    private ClientDavConnection m_connection;
    private String m_atg = "atg.tmcVerkehrsMeldung";
    private String m_asp = "asp.tmcSenden";
    private List<INeueDatenListener> m_angemeldeteListener = new LinkedList<INeueDatenListener>();
    private String m_pid;
    private String m_status;
    private String m_zustand;
    private String m_quelle;

    public RdsMeldungsEmpfang(ClientDavConnection connection, String pid) {
        this.debug = Debug.getLogger();
        this.m_connection = connection;
        this.m_pid = pid;
        this.anmeldeLeseDaV(pid, this.m_atg, this.m_asp, ReceiverRole.receiver());
    }

    public void update(ResultData[] arg0) {
        int i = 0;
        while (i < arg0.length) {
            ResultData dat = arg0[i];
            if (dat.getDataDescription().getAttributeGroup().getPid().equals(this.m_atg)) {
                String absenderPid = dat.getObject().getPid();
                if (dat.hasData()) {
                    Data vewInfo = dat.getData().getItem("TMCDaten").getItem("VerwaltungsInformationen");
                    this.m_status = vewInfo.getTextValue("TmcStatus").getText();
                    this.m_zustand = vewInfo.getItem("BearbeitungsZustand").asTextValue().getValueText();
                    this.m_quelle = vewInfo.getItem("Erzeugungsart").asTextValue().getValueText();
                    String log = "< TmcMeldung von Verwaltung (" + dat.getDataDescription().getAspect() + "):  " + new Date().toString() + ", PID: " + absenderPid + ", Status: " + this.m_status + ", Zustand: " + this.m_zustand + ",  Quelle: " + this.m_quelle;
                    System.out.println(log);
                    this.debug.info(log);
                    this.benachrichtigeListener();
                }
            }
            ++i;
        }
    }

    public String getStatus() {
        return this.m_status;
    }

    public String getQuelle() {
        return this.m_quelle;
    }

    public String getZustand() {
        return this.m_zustand;
    }

    private void anmeldeLeseDaV(String objPid, String atgPid, String aspPid, ReceiverRole role) {
        String buffer = "Anmelden am DaV (Lesen): " + objPid + " " + atgPid + "  " + aspPid;
        if (this._debugAnmelde) {
            System.out.println(buffer);
        }
        ClientDavConnection verb = this.m_connection;
        AttributeGroup atg = verb.getDataModel().getAttributeGroup(atgPid);
        Aspect asp = verb.getDataModel().getAspect(aspPid);
        DataDescription dd = new DataDescription(atg, asp);
        SystemObject obj = this.m_connection.getDataModel().getObject(objPid);
        this.m_connection.subscribeReceiver((ClientReceiverInterface)this, obj, dd, ReceiveOptions.normal(), role);
    }

    private void abmeldeLeseDaV(String objPid, String atgPid, String aspPid) {
        String buffer = "Abmelden am DaV (Lesen): " + objPid + " " + atgPid + "  " + aspPid;
        if (this._debugAnmelde) {
            System.out.println(buffer);
        }
        AttributeGroup atg = this.m_connection.getDataModel().getAttributeGroup(atgPid);
        Aspect asp = this.m_connection.getDataModel().getAspect(aspPid);
        DataDescription dd = new DataDescription(atg, asp);
        SystemObject obj = this.m_connection.getDataModel().getObject(objPid);
        this.m_connection.unsubscribeReceiver((ClientReceiverInterface)this, obj, dd);
    }

    public void dispose() {
        this.abmeldeLeseDaV(this.m_pid, this.m_atg, this.m_asp);
    }

    public void addListener(INeueDatenListener listener) {
        this.m_angemeldeteListener.add(listener);
    }

    public void removeListener(INeueDatenListener listener) {
        this.m_angemeldeteListener.remove(listener);
    }

    private void benachrichtigeListener() {
        for (INeueDatenListener l : this.m_angemeldeteListener) {
            l.neueDaten();
        }
    }
}

