/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.SystemObject;

public class TestParameterHandler
implements ClientSenderInterface {
    private ClientDavInterface dav;
    private String lmspid;
    private String meldungsAktionGesichert;
    private boolean angemeldet;
    private long meldungsRueckhaltungGesichert;

    public TestParameterHandler(ClientDavInterface dav, String lmspid) {
        this.dav = dav;
        this.lmspid = lmspid;
    }

    private Data getAktuelleDaten() {
        ConfigurationObject lms = (ConfigurationObject)this.dav.getDataModel().getObject(this.lmspid);
        AttributeGroup atg = this.dav.getDataModel().getAttributeGroup("atg.tmcMeldungsVerwaltung");
        Aspect asp = this.dav.getDataModel().getAspect("asp.parameterSoll");
        DataDescription dd = new DataDescription(atg, asp);
        ResultData data = this.dav.getData((SystemObject)lms, dd, 0L);
        return data.getData().createModifiableCopy();
    }

    private void sendeDaten(Data daten) {
        ConfigurationObject lms = (ConfigurationObject)this.dav.getDataModel().getObject(this.lmspid);
        AttributeGroup atg = this.dav.getDataModel().getAttributeGroup("atg.tmcMeldungsVerwaltung");
        Aspect asp = this.dav.getDataModel().getAspect("asp.parameterVorgabe");
        DataDescription dd = new DataDescription(atg, asp);
        ResultData data = new ResultData((SystemObject)lms, dd, System.currentTimeMillis(), daten);
        if (!this.angemeldet) {
            try {
                this.dav.subscribeSender((ClientSenderInterface)this, (SystemObject)lms, dd, SenderRole.sender());
                this.angemeldet = true;
            }
            catch (OneSubscriptionPerSendData e) {
                e.printStackTrace();
            }
        }
        try {
            this.dav.sendData(data);
        }
        catch (DataNotSubscribedException e) {
            e.printStackTrace();
        }
        catch (SendSubscriptionNotConfirmed e) {
            e.printStackTrace();
        }
    }

    public void setzeTestParameter() {
        Data neueDaten = this.getAktuelleDaten();
        this.meldungsAktionGesichert = new String(neueDaten.getTextValue("RDSMeldungsAktion").getText());
        this.meldungsRueckhaltungGesichert = neueDaten.getUnscaledValue("RDSMeldungsR\u00fcckhaltung").longValue();
        neueDaten.getTextValue("RDSMeldungsAktion").setText("0");
        neueDaten.getUnscaledValue("RDSMeldungsR\u00fcckhaltung").set(120);
        this.sendeDaten(neueDaten);
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    public void restoreParameter() {
        Data neueDaten = this.getAktuelleDaten();
        neueDaten.getTextValue("RDSMeldungsAktion").setText(this.meldungsAktionGesichert);
        neueDaten.getUnscaledValue("RDSMeldungsR\u00fcckhaltung").set(this.meldungsRueckhaltungGesichert);
        this.sendeDaten(neueDaten);
    }
}

