/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.MutableSetChangeListener;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.ste.tmcvew.RdsMeldungsAuswertung;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TmcMeldungsVerwaltung
implements ClientReceiverInterface,
MutableSetChangeListener {
    private ClientDavConnection connection;
    private static DataModel dataModel;
    private List<DynamicObject> listeMeldungen;
    private ConfigurationObject verkehrsModellNetz;
    private HashMap<String, RdsMeldungsAuswertung> meldungsAuswertung = new HashMap();

    public TmcMeldungsVerwaltung(ClientDavConnection connection, String netz) {
        this.connection = connection;
        dataModel = connection.getDataModel();
        this.verkehrsModellNetz = (ConfigurationObject)dataModel.getObject(netz);
        this.listeMeldungen = new ArrayList<DynamicObject>();
        this.verkehrsModellNetz.getMutableSet("TMCMeldungen").addChangeListener((MutableSetChangeListener)this);
        this.rdsObjekteBestimmen();
    }

    protected void rdsObjekteBestimmen() {
        if (this.verkehrsModellNetz == null) {
            return;
        }
        List liste = this.verkehrsModellNetz.getMutableSet("TMCMeldungen").getElements();
        int i = 0;
        while (i < liste.size()) {
            DynamicObject obj = (DynamicObject)liste.get(i);
            this.rdsListeVerwalten(obj);
            ++i;
        }
    }

    public HashMap<String, RdsMeldungsAuswertung> getMeldungen() {
        if (this.meldungsAuswertung.size() > 0) {
            return this.meldungsAuswertung;
        }
        return null;
    }

    private void rdsListeVerwalten(DynamicObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.isValid()) {
            if (!this.listeMeldungen.contains(obj)) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": " + obj.getPid() + " zu Liste hinzugef\u00fcgt.");
                this.listeMeldungen.add(obj);
                this.meldungsAuswertung.put(obj.getPid(), new RdsMeldungsAuswertung(this.connection, obj.getPid()));
            }
        } else {
            this.listeMeldungen.remove(obj);
            System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": " + obj.getPid() + " aus Liste gel\u00f6scht.");
            if (this.meldungsAuswertung.containsKey(obj.getPid())) {
                this.meldungsAuswertung.get(obj.getPid()).dispose();
                this.meldungsAuswertung.remove(obj.getPid());
            }
        }
    }

    public void update(ResultData[] results) {
    }

    public void update(MutableSet set, SystemObject[] addedObjects, SystemObject[] removedObjects) {
        DynamicObject obj;
        int i = 0;
        while (i < removedObjects.length) {
            obj = (DynamicObject)removedObjects[i];
            this.rdsListeVerwalten(obj);
            ++i;
        }
        i = 0;
        while (i < addedObjects.length) {
            obj = (DynamicObject)addedObjects[i];
            this.rdsListeVerwalten(obj);
            ++i;
        }
    }
}

