#!/bin/bash
#########################################################################
#                                                                       #
#          Startskript für die SWE TMC-Meldungsverwaltung               #
#                                                                       #
#  Das Skript ist als Beispiel zu betrachten und muss eventuell an die  #
#  Gegebenheiten des lokalen Projektes angepasst werden.                #
#                                                                       #
#  Es wird angenommen, dass die Kernsoftware gemeass der allgmeinen Vor-#
#  gaben installiert wurde, insbesondere die Installation der SWE in    # 
#  Einzel-Unterverzeichnissen unter dem Verzeichnis                     # 
#  "distributionspakete" und die Existenz einer allgemeinen Einstel-    #
#  lungsdatei "einstellungen.sh" im Verzeichnis "../../skripte-bash"    #
#  relativ zum Verzeichnis, in dem dieses Skript residiert, in dem die  #
#  allgemeinen Parameter für die Datenverteilerkopplung festgelegt sind.#
#                                                                       #
#########################################################################

source ../../skripte-bash/einstellungen.sh


#########################################################################
# Folgende, aus der Datei "einstellungen.sh" uebernommene Parameter,    #
# muessen ueberprueft und evtl. angepasst werden                        #
#########################################################################
# Parameter für den Java-Interpreter
#jvmArgs="-Dfile.encoding=ISO-8859-1"

# Parameter für den Datenverteiler
#dav1="-datenverteiler=localhost:8083 -benutzer=Tester \
#  -authentifizierung=passwd -debugFilePath=.."


#########################################################################
#                                                                       #
#                        Parameter der SWE                              #
#                                                                       #
#########################################################################
# Landesmeldestelle
LMS="-lms=lms.test" 

#########################################################################
#                                                                       #
#                  Ausfuehrung der Softwareeinheit                      #
#                                                                       #
# Ab hier muessen im Skript keine Aenderungen mehr vorgenommen werden.  #
#                                                                       #
#########################################################################

java $jvmArgs -jar de.bsvrz.ste.tmcvew-runtime.jar \
 $dav1 \
 -debugLevelFileText=ALL \
 -debugLevelStdErrText=NONE \
 -debugSetLoggerAndLevel=:INFO \
 $LMS \
&


