package de.bsvrz.ste.tmcvew;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;

import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.InvalidationListener;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList.Argument;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Hauptklasse zum Testen der TMC-Meldungsverwaltung.
 * <p>
 * über den Aufrufparameter "-kb" wird festgelegt, in welchen
 * Konfigurationsbereich die Objekte (typ.tmcVerkehrsMeldung) gelegt werden.
 * 
 * @author Asal
 *
 */
public class RdsMeldung implements StandardApplication, Runnable {
	static final String LMS_PID = "lms.test";
	public static final String MELDUNGEN_MENGE = "TMCMeldungen";
	private static final String MELDUNGEN_TYP = "typ.tmcVerkehrsMeldung";
	public static final String MELDUNGEN_ATG = "atg.tmcVerkehrsMeldung";

	/**
	 * Comment for <code>debug</code>
	 */
	private static Debug m_debug;
	/**
	 * Übergebene Datenverteiler Verbindung
	 */
	protected ClientDavInterface m_connection;
	/**
	 * Übergebenes Datenmodell
	 */
	protected DataModel m_dataModel;
	/**
	 * Argument Konfigurationsbereiche (-kb)
	 */
	Argument m_konfigurationsBereich;
	/**
	 * Argument KonfigurationsVerantworlicher (-kv)
	 */
	Argument m_konfigurationsVerantwortlicher;
	/**
	 * Argument Objekttyp (-objTyp)
	 */
	Argument m_objektTyp;
	/**
	 * Argument Objekttyp (-pid)
	 */
	Argument m_pid;
	/**
	 * Argument Objekttyp (-name)
	 */
	Argument m_name;
	/**
	 * String Konfigurationsbereich Kommandozeile
	 */
	private String _kb;
	/**
	 * String Konfigurationsverantworlicher Kommandozeile
	 */
	private String _kv;
	/**
	 * String Objekttyp Kommandozeile
	 */
	private String _objektTyp;
	/**
	 * String Pid Kommandozeile
	 */
	private String _pid;
	/**
	 * String name Kommandozeile
	 */
	private String _name;
	/**
	 * Testfall
	 */
	private Argument m_test;
	private String _test;
	private static Debug _debug;
	private String tmc;
	private String quelle;
	private String zustand;
	private String aspekt;
	private String status;
	private String ergebnis;
	private boolean erfolg = false;
	private boolean _erfolg = false;
	private boolean debug = true;
	private int m_teiler = 1;
	private static Process m_proc = null;

	static {
		Runtime.getRuntime().addShutdownHook(new Thread() {
			public void run() {
				prozessStop();
			}
		});
	}

	/**
	 * Objekt beinhaltet alle dynamischen Staus.
	 */
	TmcMeldungsVerwaltung m_rds_meldung;

	/**
	 * Liste mit einzelnen Konfigurationsbereichen durch Aufspaltung von _kb mit
	 * Trenner ':'
	 */
	private String[] _kb_liste = {};

	private boolean _kb_ausschluss = false;
	protected SystemObject systemobjekt;

	protected AttributeGroup _attributgruppe;

	protected Aspect _aspekt;

	protected DataDescription _datenbeschreibung;

	protected short _simulationsvariante;

	protected SenderRole _senderrolle;

	protected ConfigurationArea _konfigBereich;

	protected DynamicObjectType _dynObjTyp;

	protected ConfigurationObject _configObj;

	protected VerwaltungDynObj _verwaltung;

	/**
	 * Initialisierung von Datenverteiler
	 */
	public void initialize(ClientDavInterface connection) throws Exception {
		iniRdsMeldung(connection);
		testfall(connection, _test, 1); // Testfälle
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.bsvrz.sys.funclib.application.StandardApplication#initialize(de.bsvrz.
	 * dav.daf.main.ClientDavInterface)
	 */

	public void iniRdsMeldung(ClientDavInterface connection) throws Exception {
		_debug = Debug.getLogger();

		m_connection = (ClientDavConnection) connection;
		m_dataModel = m_connection.getDataModel();

		if (m_konfigurationsBereich == null) {
			_kb = "kb.kv.aoe.nw.nba.koeln.koblenz";
		} else {
			if (m_konfigurationsBereich.getValue().length() > 0) {
				_kb = m_konfigurationsBereich.getValue();
			} else {
				_kb = "kb.kv.aoe.nw.nba.koeln.koblenz"; // Hier Ablage
														// dynamische Objekte
														// Defaultbereich
			}
		}

		if (m_konfigurationsVerantwortlicher == null) {
			_kv = "kv.aoe.nw.nba.koeln.koblenz";
		} else {
			if (m_konfigurationsVerantwortlicher.getValue().length() > 0) {
				_kv = m_konfigurationsVerantwortlicher.getValue();
			} else {
				_kv = "kv.aoe.nw.nba.koeln.koblenz";
			}
		}

		if (m_objektTyp == null) {
			_objektTyp = MELDUNGEN_TYP;
		} else {
			if (m_objektTyp.getValue().length() > 0) {
				_objektTyp = m_objektTyp.getValue();
			} else {
				_objektTyp = MELDUNGEN_TYP;
			}
		}

		if (m_pid != null) {
			if (m_pid.getValue().length() > 0) {
				_pid = m_pid.getValue();
			}
		}

		if (m_name != null) {
			if (m_name.getValue().length() > 0) {
				_name = m_name.getValue();
			}
		}

		if (m_test != null) {
			if (m_test.getValue().length() > 0) {
				_test = m_test.getValue();
			}
		}
	}

	/**
	 * Initialisiert den Empfangsthread.
	 * 
	 * @param text
	 *            Parametertext
	 */
	public void iniTest(final String text) {
		ergebnis = text;
		try {
			Thread.sleep(2000);
		} catch (final InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // 2 Sekunden
	}

	/**
	 * Thread für Überwachung der Rückmeldetelegramme. Der Thread wird
	 * sekündlich durchlaufen. Ist ein Testlauf beendet wird auch der Thread
	 * beendet.
	 */

	public void run() {
		boolean _test = false;
		boolean ok = false;
		boolean loesche = true;
		boolean fehler = true;

		String _testnummer_old = null;
		long flag = 0;
		long zaehler = -1;
		long zaehler_min = -1;

		HashMap<String, RdsMeldungsAuswertung> empfMeldung = new HashMap<String, RdsMeldungsAuswertung>();

		RdsMeldungsAuswertung rdsa = new RdsMeldungsAuswertung();

		while (true) {
			// 1. Kennung -> Laufende Nummer im Test bei 0 ist Testlauf beendet
			// 2. Kennung -> Erster Status
			// 3. Kennung -> Erster Zustand
			// 4. Kennung -> Erste Quelle
			// 5. Kennung -> Zeit in Sekunden in der Rückmeldung erwartet wird,
			// bei 0 wird kein Telegramm erwartet
			// 6. Kennung -> Zeit in Sekunden in der Rückmeldung nicht erwartet
			// wird, bei 0 wird kein Telegramm erwartet

			if (ergebnis != null) {
				String v[] = ergebnis.split(":");

				String _testnummer = v[0];
				String _status = v[1];
				String _zustand = v[2];
				String _quelle = v[3];
				String _zeit = v[4];
				String _zeit_min = v[5];

				// Initialisiere neuen Testfall

				if (!_testnummer.equalsIgnoreCase(_testnummer_old)) {
					if (debug) {
						System.out.println("Rdsmeldung-Thread -> Initialisiere Test: " + _testnummer + ", Objekt: '"
								+ tmc + "'" + ", TestParameter: " + ergebnis);
					}

					loesche = true;
					_testnummer_old = _testnummer;

					try {
						zaehler = Long.parseLong(_zeit);

						if (zaehler > m_teiler) {
							zaehler = zaehler / m_teiler;
						}

						if (zaehler == 0) {
							zaehler = -1;
						}

						zaehler_min = Long.parseLong(_zeit_min);

						if (zaehler_min > m_teiler) {
							zaehler_min = zaehler_min / m_teiler;
						}

						if (zaehler_min == 0) {
							zaehler_min = -1;
						}
					} catch (Exception e) {
						zaehler = -1;
						e.printStackTrace();
					}

				}

				if (zaehler > 0) {
					zaehler--;
				}

				if (zaehler_min > 0) {
					zaehler_min--;
				}

				if (zaehler == 0) {
					System.out.println("Rdsmeldung-Thread -> Fehlende Meldung " + tmc);
					zaehler = -1;
					fehler = false;
				}

				// if (debug) {
				// System.out.println("Rdsmeldung-Thread -> ZM: " +
				// zaehler_min);
				// }

				if (m_rds_meldung.getMeldungen() != null) {
					empfMeldung = m_rds_meldung.getMeldungen();
				}

				if (empfMeldung != null) {
					rdsa = empfMeldung.get(tmc); // Hole Meldung für empfangenes
													// Objekt
				} else {
					rdsa = null;
				}

				if (rdsa != null) {
					// if (debug) {
					// System.out.println("Rdsmeldung-Thread -> Meldung: " +
					// rdsa.getPid() + ", Flag: " + rdsa.getFlag());
					// }

					if (rdsa.getFlag() == 0) { // neues TMC-Objekt
						flag = 0;
					}

					if (rdsa.getFlag() != flag) {
						flag = rdsa.getFlag();
						zaehler = -1;

						if ("0".equalsIgnoreCase(_zeit)) {
							System.out.println("Rdsmeldung-Thread -> " + new Date().toString() + 
									", Unwartete Meldung " + rdsa.getPid());
							fehler = false;
						}

						if (zaehler_min > 0) {
							System.out.println("Rdsmeldung-Thread -> Meldung zu früh " + rdsa.getPid());
							fehler = false;
						}

						if (rdsa.getParameter().getQuelle().equalsIgnoreCase(_quelle)
								&& rdsa.getParameter().getZustand().equalsIgnoreCase(_zustand)
								&& rdsa.getParameter().getStatus().equalsIgnoreCase(_status)) {
							if (debug) {
								System.out.println("Rdsmeldung-Thread -> Meldung ok " + rdsa.getPid());
							}

							if ("Geändert".equalsIgnoreCase(_status)) {
								ok = tmcmeldung(m_connection, tmc, quelle, _zustand, "versendet", "0");
							}

							if ("Gelöscht".equalsIgnoreCase(_status)) {
								_erfolg = false;

								// Installiere Listener auf gelöschtes Objekt

								((DynamicObject) m_dataModel.getObject(rdsa.getPid()))
										.addListenerForInvalidation(new InvalidationListener() {

											public void invalidObject(final DynamicObject arg0) {
												// System.out.println("Rdsmeldung-Thread
												// -> Objekt: "+tmc+"
												// gelöscht");
												_erfolg = true;
											}
										});

								ok = tmcmeldung(m_connection, tmc, quelle, _zustand, "versendet", "9");

								try { // Objekt soll gelöscht werden, Prüfe nach
										// 5 Sekunden ob Löschung erfolgreich
									Thread.sleep(5000);
								} catch (final InterruptedException e) {
									e.printStackTrace();
								}

								if (!_erfolg) { // Objekt nicht gelöscht
									fehler = false;
									System.out.println(
											"Rdsmeldung-Thread -> Objekt: " + rdsa.getPid() + " nicht gelöscht");
								}
							}

							if ("Aufhebung".equalsIgnoreCase(_status)) {
								ok = tmcmeldung(m_connection, tmc, quelle, _zustand, "versendet", "1");
							}
						} else {
							System.out.println("Rdsmeldung-Thread ->  " + new Date().toString() + ", Falsche Meldung " + rdsa.getPid());
							fehler = false;
						}
					}
				} // ende Meldung empfangen

				if ("0".equalsIgnoreCase(_testnummer)) {
					if (!fehler) {
						erfolg = fehler;
						if (debug) {
							System.out.println("Rdsmeldung-Thread -> Testlauf mit Fehler beendet ");
						}
					} else {
						erfolg = fehler;
						if (debug) {
							System.out.println("Rdsmeldung-Thread -> Testlauf erfolgreich beendet ");
						}
					}
					break; // Thread beenden für Junit - Test
				}
			}

			// Zeitstufe eine Sekunde

			try {
				Thread.sleep(1000);
			} catch (final InterruptedException e) {
				e.printStackTrace();
			}
		}

		// if (debug) {
		// System.out.println("Rdsmeldung-Thread -> ENDE");
		// }
	}

	/**
	 * Versendet eine TMC - Meldung.
	 * 
	 * @param connection
	 *            Verbindung zum Datenverteiler
	 * @param pid
	 *            Meldungsobjekt ( TMCMeldung )
	 * @param quelleP
	 *            Meldungsquelle
	 * @param zustandP
	 *            Meldungszustand
	 * @param aspektP
	 *            Meldungsaspekt
	 * @param statusP
	 *            Meldungsstatus
	 * @return true, wenn Ergebnis erfolgreich.
	 */

	public boolean tmcmeldung(final ClientDavInterface connection, final String pid, final String quelleP,
			final String zustandP, final String aspektP, final String statusP) {
		final ConfigurationObject netz = (ConfigurationObject) m_dataModel.getObject(LMS_PID);
		final List<SystemObject> liste = netz.getMutableSet(MELDUNGEN_MENGE).getElements();

		if (!"versendet".equalsIgnoreCase(aspektP)) {
			final String log = "> TmcMeldung (" + aspektP + "):  " + new Date().toString() + ", PID: " + pid
					+ ", Status: " + getInternalStatusText(statusP) + ", Zustand: " + zustandP + ",  Quelle: " + quelleP;
			System.out.println(log);
			_debug.info(log);
		}

		for (int i = 0; i < liste.size(); i++) {
			final DynamicObject obj = (DynamicObject) liste.get(i);

			if (obj.getPid().equalsIgnoreCase(pid)) {
				final Meldung melde = new Meldung(connection, obj, aspektP);

				// Quelle, String zustand, String aspekt, String status
				melde.send(melde.getResultData(quelleP, zustandP, aspektP, statusP));

				// melde.dispose(); // Abmelden
			}
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * de.bsvrz.sys.funclib.application.StandardApplication#parseArguments(de.
	 * bsvrz.sys.funclib.commandLineArgs.ArgumentList)
	 */
	public void parseArguments(ArgumentList argumentList) throws Exception {
		m_debug = Debug.getLogger();

		m_konfigurationsBereich = argumentList.fetchArgument("-kb=");
		m_debug.info("KonfigurationsBereich " + m_konfigurationsBereich.getValue());
		m_konfigurationsVerantwortlicher = argumentList.fetchArgument("-kv=");
		m_debug.info("KonfigurationsVerantworlicher " + m_konfigurationsVerantwortlicher.getValue());
		m_objektTyp = argumentList.fetchArgument("-objTyp=");
		m_debug.info("Objekttyp " + m_objektTyp.getValue());
		m_pid = argumentList.fetchArgument("-pid=");
		m_debug.info("Pid " + m_pid.getValue());
		m_name = argumentList.fetchArgument("-name=");
		m_debug.info("Name " + m_name.getValue());
		m_test = argumentList.fetchArgument("-test=");

	}

	/**
	 * Statische Methode für das Starten des Programms.
	 * 
	 * @param args
	 *            Kommandozeilen-Parameter
	 */
	public static void main(String[] args) {
		try {
			StandardApplicationRunner.run(new RdsMeldung(), args);
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Erstellung der Konfigurationsobjekte.
	 * 
	 * @throws Exception
	 *             bei Fehlern
	 */
	protected void erstelleRdsMeldung() throws Exception {

		// System.out.println("Start erstelle RdsMeldung: "+ _objektTyp);

		try {
			_konfigBereich = m_dataModel.getConfigurationArea(_kb);
			_dynObjTyp = (DynamicObjectType) m_dataModel.getType(_objektTyp);
			_configObj = (ConfigurationObject) m_dataModel.getObject(_kv);
		} catch (final RuntimeException e) {
			// TODO Automatisch erstellter Catch-Block
			e.printStackTrace();
		}

		_attributgruppe = m_dataModel.getAttributeGroup("atg.rdsMeldungsVerwaltung");
		_aspekt = m_dataModel.getAspect("asp.parameterVorgabe");

		_verwaltung = new VerwaltungDynObj(m_connection, m_dataModel, _konfigBereich, _dynObjTyp, _configObj,
				_attributgruppe, _aspekt);

		// System.out.println("Start erstelle RdsMeldung");

		if ((_pid != null) && (_name != null)) {
			// System.out.println("RdsMeldung Pid vorhanden: "+_pid);
			erzeuge(_pid, _name, "", null);
		} else {
			Data[] data = new Data[1];

			// data[0] = konfDatenSetzen("gültig", 3300, "VRZ-intern");

			// System.out.println("RdsMeldung Lösche ");

			ConfigurationObject netz = (ConfigurationObject) m_dataModel.getObject(LMS_PID);

			// netz.getMutableSet("RDSMeldungen").remove(m_dataModel.getObject("TMCMeldung1"));
			// netz.getMutableSet("RDSMeldungen").remove(m_dataModel.getObject("TMCMeldung2"));
			// netz.getMutableSet("RDSMeldungen").remove(m_dataModel.getObject("TMCMeldung3"));
			// netz.getMutableSet("RDSMeldungen").remove(m_dataModel.getObject("TMCMeldung4"));
			// netz.getMutableSet("RDSMeldungen").remove(m_dataModel.getObject("TMCMeldung5"));
			// netz.getMutableSet("RDSMeldungen").remove(m_dataModel.getObject("TMCMeldung6"));

			loesche("TMCMeldung1");
			loesche("TMCMeldung2");
			loesche("TMCMeldung3");
			loesche("TMCMeldung4");
			loesche("TMCMeldung5");
			loesche("TMCMeldung6");

			erzeuge("TMCMeldung1", "TMCMeldung 1", "", null);
			netz.getMutableSet(MELDUNGEN_MENGE).add(_verwaltung.getDynamicObject());
			erzeuge("TMCMeldung2", "TMCMeldung 2", "", null);
			netz.getMutableSet(MELDUNGEN_MENGE).add(_verwaltung.getDynamicObject());
			erzeuge("TMCMeldung3", "TMCMeldung 3", "", null);
			netz.getMutableSet(MELDUNGEN_MENGE).add(_verwaltung.getDynamicObject());
			erzeuge("TMCMeldung4", "TMCMeldung 4", "", null);
			netz.getMutableSet(MELDUNGEN_MENGE).add(_verwaltung.getDynamicObject());
			erzeuge("TMCMeldung5", "TMCMeldung 5", "", null);
			netz.getMutableSet(MELDUNGEN_MENGE).add(_verwaltung.getDynamicObject());
			erzeuge("TMCMeldung6", "TMCMeldung 6", "", null);
			netz.getMutableSet(MELDUNGEN_MENGE).add(_verwaltung.getDynamicObject());

			// parametriere("gültig", 2000, "VRZ-intern");
			// parametriereSituation();
			// erzeuge("baustelleNw101", "Baustelle NW101", "", null);
			// netz.getMutableSet("Baustellen").add(_verwaltung.getDynamicObject());
			// parametriere("gültig", 2000, "VRZ-intern");
			// parametriereSituation();

		}

		// System.out.println("Ende erstelle RdsMeldung");

	}

	// /**
	// * Diese Methode überprüft den Konfigurationsbereich des übergebenen
	// * Objekts. Ist die Liste der Konfigurationsbereiche leer, wird 'true'
	// * zurückgegeben. Ist die Liste der Konfigurationsbereiche nicht leer, so
	// * wird nur dann 'true' zurückgegeben, wenn der Konfigurationsbereich des
	// * Objektes in der Liste aufgeführt ist und die Liste nicht als Ausschluss
	// * dient
	// *
	// * @param objekt
	// * zu prüfendes Objekt
	// * @return true, wenn der Konfigurationsbereich des zu prüfendes Objekt in
	// * der Liste der Konfigurationsbereiche vorhanden oder die Liste
	// * leer ist
	// */
	// protected boolean pruefeKb(ConfigurationObject objekt) {
	// boolean ergebnis = _kb_ausschluss;
	//
	// if (_kb_liste.length == 0) {
	// ergebnis = true;
	// } else {
	// String kb = objekt.getConfigurationArea().getPid();
	//
	// for (int i = 0; i < _kb_liste.length; i++) {
	// if (kb.equals(_kb_liste[i])) {
	// if (_kb_ausschluss) {
	// ergebnis = false;
	// } else {
	// ergebnis = true;
	// }
	//
	// break;
	// }
	// }
	// }
	//
	// return ergebnis;
	// }

	public void update(final MutableSet arg0, final SystemObject[] arg1, final SystemObject[] arg2) {
		try {
			System.out.println("update Menge: " + arg0.getName());

			if (arg1 != null) {
				for (int i = 0; i < arg1.length; i++) {
					System.out.println("added - " + arg1[i]);

				}
			}

			if (arg2 != null) {
				for (int i = 0; i < arg2.length; i++) {
					System.out.println("removed - " + arg2[i]);
				}
			}
		} catch (final RuntimeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public void erzeuge(String pid, String name, String set, Data[] data) {

		if (_verwaltung.erzeugeObjekt(pid, name, set, data)) {
			// System.out.println("DynObject '" + pid + "'" + " erzeugt");

			if (set.length() > 0) {
				_verwaltung.hinzufuegeZuMenge(MELDUNGEN_MENGE);
			}

		} else {
			System.out.println("DynObject '" + pid + "'" + " konnte nicht erzeugt werden");

			// throw new IllegalArgumentException();
		}
	}

	public void parametriere(String _status, int vkfz, String _veranlasser) {

		final Data data = m_connection.createData(_attributgruppe);

		if (data != null) {
			data.getItem("Status").asTextValue().setText(_status);
			data.getItem("RestKapazität").asUnscaledValue().set(vkfz);
			data.getItem("Veranlasser").asTextValue().setText(_veranlasser);
		}

		final DataDescription dd = new DataDescription(_attributgruppe, _aspekt);

		final ResultData rd = new ResultData(_verwaltung.getDynamicObject(), dd, new Date().getTime(), data);

		_verwaltung.parametriere(dd, rd);

	}

	public void parametriereSituation() {
		AttributeGroup atg = m_dataModel.getAttributeGroup("atg.situationsEigenschaften");
		Data data = m_connection.createData(atg);

		if (data != null) {
			GregorianCalendar gk = new GregorianCalendar();

			data.getItem("StartZeit").asTimeValue().setMillis(gk.getTimeInMillis());
			data.getItem("Dauer").asTimeValue().setSeconds(3600);
			data.getItem("StraßenSegment").asReferenceArray().setLength(0);
			data.getItem("StartOffset").asUnscaledValue().set(100);
			data.getItem("EndOffset").asUnscaledValue().set(90);
		}

		DataDescription dd = new DataDescription(atg, _aspekt);

		ResultData rd = new ResultData(_verwaltung.getDynamicObject(), dd, new Date().getTime(), data);

		_verwaltung.parametriere(dd, rd);

	}

	public Data konfDatenSetzen(String _status, int vkfz, String _veranlasser) {
		Data data = null;

		data = m_connection.createData(_attributgruppe);

		if (data != null) {
			data.getItem("Status").asTextValue().setText(_status);
			data.getItem("RestKapazität").asUnscaledValue().set(vkfz);
			data.getItem("Veranlasser").asTextValue().setText(_veranlasser);
		}

		return data;
	}

	public void konfiguriere(Data data) {

		if (data == null) {
			return;
		}

		DataDescription dd = new DataDescription(_attributgruppe, _aspekt);

		ResultData rd = new ResultData(_verwaltung.getDynamicObject(), dd, new Date().getTime(), data);

		_verwaltung.konfiguriere(rd);
	}

	public void loesche(final String pid) {

		if (pid.length() > 0) {
			_verwaltung.loesche(pid);

		} else {
			throw new IllegalArgumentException();
		}

	}

	/**
	 * Loescht alle TMC-Objekte und legt diese neu an
	 */
	public void loescheTMCObjekte() {

		try {
			erstelleRdsMeldung();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		// Menge verwalten

		ConfigurationObject netz = (ConfigurationObject) m_dataModel.getObject(LMS_PID);
		List liste = netz.getMutableSet(MELDUNGEN_MENGE).getElements();

		for (int i = 0; i < liste.size(); i++) {
			DynamicObject obj = (DynamicObject) liste.get(i);

			// System.out.println("RDSMeldung " + obj + " Id " + obj.getId() + "
			// gültig " + obj.getValidSince() + " bis " + obj.getNotValidSince()
			// + " noch gültig " + obj.isValid());

			if (!obj.isValid()) {
				try {
					netz.getMutableSet(MELDUNGEN_MENGE).remove(obj);
				} catch (ConfigurationChangeException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			} else {
				obj.addListenerForInvalidation(new InvalidationListener() {

					public void invalidObject(DynamicObject dynamicObject) {
						// System.out.println(".invalidObject() Objekt " +
						// dynamicObject.getPid() + " wurde ungültig");
						// Menge verwalten

						ConfigurationObject netz = (ConfigurationObject) m_dataModel.getObject(LMS_PID);
						List liste = netz.getMutableSet(MELDUNGEN_MENGE).getElements();

						try {
							netz.getMutableSet(MELDUNGEN_MENGE).remove(dynamicObject);
						} catch (ConfigurationChangeException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}

				});
			}
		} // ende for
	}

	/**
	 * Testfälle für automatische JUnit - Tests.
	 * 
	 * @param connection
	 *            {@link ClientDavInterface}
	 * @param test
	 *            Name des Tests
	 * @param teiler
	 *            Teiler
	 * @return <code>true</code>, wenn Test ok, sonst <code>false</code>
	 * @throws Exception
	 *             bei Fehlern
	 */

	public boolean testfall(final ClientDavInterface connection, final String test, final int teiler) throws Exception {

		System.out.println("TMCMeldung -> Lösche alle Objekte  ");

		m_teiler = teiler;

		loescheTMCObjekte();

		System.out.println("TMCVerkehrsMeldung -> --- Starte Prozess TmcMeldungsVerwaltung -----");

		m_rds_meldung = new TmcMeldungsVerwaltung((ClientDavConnection) m_connection, LMS_PID);

		/*
		 * Neu Sans 20090216 START
		 ***********************************************/
		// einige Zeit, bis die abhängigen Prozesse und Threads die
		// Löschungen und Neuanmeldungen
		// verarbeitet haben
		Thread.sleep(2000);
		/*
		 * Neu Sans 20090216 Ende
		 ************************************************/

		final Thread thread = new Thread(this);
		thread.setName(this.getClass().getName());

		thread.start();

		// --------------------------------------------------------------------------------------------
		// Testfall 1
		// --------------------------------------------------------------------------------------------
		boolean ok = false;

		if (test.equalsIgnoreCase("Testfall1")) {
			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			System.out.println(
					"Start Testfall 1: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			iniTest("1:Geändert:nicht quittiert:automatisch:200:0");

		}

		// --------------------------------------------------------------------------------------------
		// Testfall 2
		// --------------------------------------------------------------------------------------------

		if ("Testfall2".equalsIgnoreCase(test)) {
			tmc = "TMCMeldung2";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 2: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			// 1. Kennung -> Laufende Nummer im Test bei 0 ist Testlauf beendet
			// 2. Kennung -> Erster Status
			// 3. Kennung -> Erster Zustand
			// 4. Kennung -> Erste Quelle
			// 5. Kennung -> Zeit in Sekunden in der Rückmeldung erwartet wird,
			// bei 0 wird kein Telegramm erwartet
			// 6. Kennung -> Zeit in Sekunden in der Rückmeldung nicht erwartet
			// wird, bei 0 wird kein Telegramm erwartet

			// Für Auswertung Telegramm bei 0: wird kein Telegramm erwartet
			iniTest("1:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			if (debug) {
				System.out.println("Testfall 2: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   "
						+ status + " --> " + ok);
			}

			Thread.sleep(20000 / teiler); // Sleep 20 Sekunden

			tmc = "TMCMeldung2";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 2a: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("2:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			if (debug) {
				System.out.println("Testfall 2a: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   "
						+ status + " --> " + ok);
			}
		}

		// --------------------------------------------------------------------------------------------
		// Testfall 3
		// --------------------------------------------------------------------------------------------

		if ("Testfall3".equalsIgnoreCase(test)) {
			tmc = "TMCMeldung3";
			quelle = "Automatik";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 3: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("1:Geändert:editiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(20000 / teiler); // Sleep 20 Sekunden

			tmc = "TMCMeldung3";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 3a: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("2:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);
		}
		// --------------------------------------------------------------------------------------------
		// Testfall 4
		// --------------------------------------------------------------------------------------------

		if ("Testfall4".equalsIgnoreCase(test)) {
			tmc = "TMCMeldung4";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 4: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("1:Geändert:nicht quittiert:automatisch:180:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(200000 / teiler); // Sleep 200 Sekunden

			tmc = "TMCMeldung4";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 4a: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("2:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(30000 / teiler); // Sleep 30 Sekunden

			tmc = "TMCMeldung4";
			quelle = "Automatik";
			zustand = "verworfen";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 4b: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("3:Gelöscht:verworfen:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);
		}

		// --------------------------------------------------------------------------------------------
		// Testfall 5
		// --------------------------------------------------------------------------------------------

		if ("Testfall5".equalsIgnoreCase(test)) {
			tmc = "TMCMeldung5";
			quelle = "manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 1: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("1:Geändert:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);
		}

		// --------------------------------------------------------------------------------------------
		// Testfall 6
		// --------------------------------------------------------------------------------------------

		if ("Testfall6".equalsIgnoreCase(test)) {
			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-1: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("1:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-2: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("2:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-3: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("3:Geändert:nicht quittiert:automatisch:180:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-4: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("4:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-5: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("5:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-6: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("6:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-7: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("7:Geändert:nicht quittiert:automatisch:180:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-8: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("8:Geändert:editiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(120000 / teiler); // Sleep 120 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-9: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("9:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-10: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("10:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-11: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("11:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-12: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("12:Geändert:nicht quittiert:automatisch:180:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-13: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("13:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "verworfen";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-14: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("14:Gelöscht:verworfen:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-15: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + getInternalStatusText(status));
			}

			iniTest("15:Gelöscht:verworfen:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-16: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("16:Gelöscht:verworfen:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(120000 / teiler); // Sleep 120 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-17: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("17:Gelöscht:verworfen:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "9";

			if (debug) {
				System.out.println("Start Testfall 6-18: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("18:Gelöscht:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(240000 / teiler); // Sleep 240 Sekunden

			tmc = "TMCMeldung6";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-19: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("19:Geändert:nicht quittiert:automatisch:180:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden

			tmc = "TMCMeldung6";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "9";

			if (debug) {
				System.out.println("Start Testfall 6-20: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("20:Gelöscht:nicht quittiert:automatisch:180:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(150000 / teiler); // Sleep 150 Sekunden damit Testfall
											// nicht abbricht

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-21: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("21:Geändert:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 6-22: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			iniTest("22:Geändert:editiert:manuell:5:0");

			Thread.sleep(360000 / teiler); // Sleep 360 Sekunden

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "9";

			if (debug) {
				System.out.println("Start Testfall 6-23: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("23:Gelöscht:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			if (debug) {
				System.out.println("Testfall 6 beendet");
			}
		}

		// --------------------------------------------------------------------------------------------
		// Testfall 7
		// --------------------------------------------------------------------------------------------

		if ("Testfall7".equalsIgnoreCase(test)) {
			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-1: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("1:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-2: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("2:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-3: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("3:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-4: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("4:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-5: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("5:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-6: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("6:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-7: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("7:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-8: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("8:Geändert:editiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(120000 / teiler); // Sleep 120 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-9: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("9:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-10: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("10:Geändert:quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-11: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("11:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-12: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("12:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "quittiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-13: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("13:Geändert:quittiert:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "verworfen";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-14: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("14:Gelöscht:verworfen:automatisch:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-15: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("15:Gelöscht:verworfen:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-16: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("16:Gelöscht:verworfen:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(120000 / teiler); // Sleep 120 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-17: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("17:Gelöscht:verworfen:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(60000 / teiler); // Sleep 60 Sekunden
			// Thread.sleep(2000);

			tmc = "TMCMeldung1";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "9";

			if (debug) {
				System.out.println("Start Testfall 7-18: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("18:Gelöscht:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(240000 / teiler); // Sleep 240 Sekunden

			tmc = "TMCMeldung6";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-19: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("19:Geändert:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000 / teiler); // Sleep 180 Sekunden

			tmc = "TMCMeldung6";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "9";

			if (debug) {
				System.out.println("Start Testfall 7-20: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("20:Gelöscht:nicht quittiert:automatisch:0:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(150000 / teiler); // Sleep 150 Sekunden damit Testfall
											// nicht abbricht

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-21: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("21:Geändert:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000 / teiler); // Sleep 300 Sekunden

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			if (debug) {
				System.out.println("Start Testfall 7-22: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			iniTest("22:Geändert:editiert:manuell:5:0");

			Thread.sleep(360000 / teiler); // Sleep 360 Sekunden

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "9";

			if (debug) {
				System.out.println("Start Testfall 7-23: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt
						+ "   " + status);
			}

			iniTest("23:Gelöscht:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			if (debug) {
				System.out.println("Testfall 7 beendet");
			}
		}

		// --------------------------------------------------------------------------------------------
		// Testfall 8 ( Kein offizieller Prüffall )
		// --------------------------------------------------------------------------------------------

		if (test.equalsIgnoreCase("Testfall8")) {
			tmc = "TMCMeldung6";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			System.out.println(
					"Start Testfall 8-1: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			iniTest("1:Geändert:nicht quittiert:automatisch:125:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(180000); // Sleep 180 Sekunden

			tmc = "TMCMeldung6";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "9";

			System.out.println(
					"Start Testfall 8-2: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			iniTest("2:Löschung:nicht quittiert:automatisch:125:100");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(125000); // Sleep 125 Sekunden damit Testfall nicht
									// abbricht
		}

		// --------------------------------------------------------------------------------------------
		// Testfall 9 ( Kein offizieller Prüffall )
		// --------------------------------------------------------------------------------------------

		if (test.equalsIgnoreCase("Testfall9")) {
			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			System.out.println(
					"Start Testfall 9-1: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			iniTest("1:Geändert:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(300000); // Sleep 300 Sekunden

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "0";

			System.out.println(
					"Start Testfall 9-2: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			iniTest("2:Geändert:editiert:manuell:5:0");

			Thread.sleep(360000); // Sleep 360 Sekunden

			tmc = "TMCMeldung5";
			quelle = "Manuell";
			zustand = "editiert";
			aspekt = "bearbeitet";
			status = "9";

			System.out.println(
					"Start Testfall 9-3: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			iniTest("3:Löschung:editiert:manuell:5:0");

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

		}
		// --------------------------------------------------------------------------------------------
		// Testfall 10 Löschen einer Meldung ( Kein offizieller Prüffall )
		// --------------------------------------------------------------------------------------------

		if (test.equalsIgnoreCase("Testfall10")) {
			tmc = "TMCMeldung3";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "0";

			System.out.println(
					"Start Testfall 10: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);

			Thread.sleep(130000); // Sleep 130 Sekunden

			tmc = "TMCMeldung3";
			quelle = "Automatik";
			zustand = "nicht quittiert";
			aspekt = "generiert";
			status = "9";

			System.out.println(
					"Start Testfall 10a: " + tmc + "   " + quelle + "   " + zustand + "   " + aspekt + "   " + status);

			ok = tmcmeldung(connection, tmc, quelle, zustand, aspekt, status);
		}

		try {
			Thread.sleep(5000); // Sleep 5 Sekunden
		} catch (final InterruptedException ie) {
			ie.printStackTrace();
		}

		iniTest("0:Geändert:quittiert:automatisch:0:0"); // Testlauf beendet

		Thread.sleep(5000); // Sleep 5 Sekunden

		return ok;
	}

	/**
	 * Startet den zu prüfenden Prozess, Installiert eine
	 * Datenverteilerverbindung.
	 * 
	 * @param connection
	 *            Verbindung zum Datenverteiler
	 * @param text
	 *            Ausgabe eines Starttextes
	 * @return Verbindung zum Datenverteiler
	 * @throws Exception
	 *             wenn keine Verbindung möglich
	 */
	public ClientDavInterface prozessStart(ClientDavInterface connection, String text) throws Exception {
		// Debug-Level setzen

		Debug.setLoggerLevel("DEFAULT", Debug.OFF);
		// Debug.setHandlerLevel("StdErr", Debug.CONFIG);
		Debug.setHandlerLevel("StdErr", Debug.INFO);

		// Datenverteilerverbindung aufbauen

		// ClientDavParameters parameters = new ClientDavParameters();
		// parameters.setDavCommunicationAddress("192.0.1.128");
		// parameters.setDavCommunicationSubAddress(8085);
		// parameters.setUserName("Tester");
		// parameters.setUserPassword("geheim");

		/*
		 * Neu Sans 20090216 START
		 ***********************************************/

		// Einzige Stelle, an der diese Infos - insbesondere IP/Port - gesetzt
		// werden
		// (auch für den zu prüfenden Prozess)
		// String datenverteiler = "192.0.1.128:8085";
		// String datenverteiler = "192.0.1.151:8083";
		final String datenverteiler = "127.0.0.1:8083";
		final String benutzer = "Tester";
		final String authentifizierung = "passwd";
		final String[] davParameter = new String[] { "-datenverteiler=" + datenverteiler, "-benutzer=" + benutzer,
				"-authentifizierung=" + authentifizierung };

		final ClientDavParameters parameters = new ClientDavParameters(davParameter);

		/*
		 * Neu Sans 20090216 ENDE
		 ************************************************/
		connection = new ClientDavConnection(parameters);
		connection.connect();
		connection.login();

		// Starte Prüfapplikation

		// String aufruf = "java -cp
		// \"C:/Projekte/Eclipse_Workspaces/de.bsvrz.ste.rdstmcvew/bin\";" +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.dav.daf/de.bsvrz.dav.daf.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.application/de.bsvrz.sys.funclib.application.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.debug/de.bsvrz.sys.funclib.debug.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.crypt/de.bsvrz.sys.funclib.crypt.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.dataSerializer/de.bsvrz.sys.funclib.dataSerializer.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.concurrent/de.bsvrz.sys.funclib.concurrent.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.timeout/de.bsvrz.sys.funclib.timeout.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.operatingMessage/de.bsvrz.sys.funclib.operatingMessage.jar;"
		// +
		// "C:/kernsoftware-3.4.3-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.dambach/de.bsvrz.sys.funclib.dambach.jar;"
		// +
		// "C:/kernsoftware-3.4.2-beispielsystem/distributionspakete/de.bsvrz.sys.funclib.commandLineArgs/de.bsvrz.sys.funclib.commandLineArgs.jar"
		// +
		// " de.bsvrz.ste.rdstmcvew.RDSVerwaltungApp " +
		// "-datenverteiler=192.0.1.128:8085 " +
		// "-benutzer=Tester " +
		// "-debugLevelStdErrText=NONE " +
		// "-authentifizierung=C:/Kernsoftware-3.4.2-beispielsystem/skripte-dosshell/passwd
		// " +
		// "-lms=bwLandesMeldeStelle " +
		// "-löschen=0";

		/*
		 * Neu Sans 20090216 START
		 ***********************************************/

		final String separator = "/"; // System.getProperty("file.separator");
		final String javaHome = System.getProperty("java.home");
		final String classPath = "\"" + System.getProperty("java.class.path") + "\"";

		final ClientDavParameters params = connection.getClientDavParameters();
		final String dav = params.getDavCommunicationAddress() + ":" + params.getDavCommunicationSubAddress();
		final String user = params.getUserName();

		String aufruf = javaHome + separator + "bin" + separator + "java";
		// aufruf += " -Dfile.encoding=UTF-8 ";
		aufruf += " -cp " + classPath + " -Xmx300m ";
		aufruf += "de.bsvrz.ste.tmcvew.TMCVerwaltungApp";
		aufruf += " -datenverteiler=" + dav;
		aufruf += " -benutzer=" + user;
		aufruf += " -authentifizierung=" + "passwd"; // Passwortdatei im
														// Arbeitsverzeichnis!
														// (in Eclipse
														// Projektverz.)
		aufruf += " -lms=" + LMS_PID;
//		aufruf += " -löschen=" + "0";
		aufruf += " -debugLevelStdErrText=" + "INFO";

		/*
		 * Neu Sans 20090216 ENDE
		 ************************************************/

		// TEST Gieseler
		final boolean startproc = true;
		if (!startproc) {
			System.out.println("TMCVerkehrsMeldung -> --- Externer Start Prozess TMCVerwaltungApp -----");
			Thread.sleep(10000); // zeit bis zu prüfender Prozess gestartet
		} else {
		
		System.out.println("TMCVerkehrsMeldung -> --- Starte Prozess TMCVerwaltungApp -----");
		try {
			m_proc = Runtime.getRuntime().exec(aufruf);

			// if(m_debug != null ) // Ausgabe von Fehlermeldungen
			// {
			// Lenke stderr von zu prüfenendem Prozess auf eigene stderr um -
			// debugLevel ist derjenige, der dem zu prüfenenden Prozess mit
			// -debugLevelStdErrText= übergeben wurde
			final InputStream is = m_proc.getErrorStream();

			new Thread() {
				private byte[] text = new byte[1024];

				@Override
				public void run() {
					while (true) {
						try {
							if (is.available() != 0) {
								final int anzahl = is.read(text);

								System.err.println("" + new String(text, 0, anzahl));
							} else {
								sleep(100);
							}
						} catch (final IOException e) {
							break;
						} catch (final InterruptedException e) {
							// TODO Automatisch erstellter Catch-Block
							e.printStackTrace();
						}
					}
				}
			}.start(); // Thread
			// }
		} catch (final IOException e) {
			System.err.println("Fehler beim Starten der Inkarnation " + "de.bsvrz.ste.tmcvew.TMCVerwaltungApp");
		}

		try {
			System.out.println(text);
			Thread.sleep(5000); // zeit bis zu prüfender Prozess gestartet
			if (!m_proc.isAlive()) {
				throw new IllegalStateException("Prozess TMCVerwaltungApp konnte nicht gestartet werden");
			}
			Thread.sleep(10000); // zeit bis zu prüfender Prozess gestartet
		} catch (final InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} // 2 Sekunden
		
		}

		return connection;
	}

	/**
	 * Stoppt den zu prüfenden Prozess.
	 */
	public static void prozessStop() {
		if (m_proc != null) {
			System.out.println("TMCVerkehrsMeldung -> --- Stoppe Prozess TMCVerwaltungApp -----");
			m_proc.destroy();
			m_proc = null;
		}
	}

	private String getInternalStatusText(final String status) {
		if ("0".equalsIgnoreCase(status)) {
			return "Geändert";
		}

		if ("1".equalsIgnoreCase(status)) {
			return "Gelöscht";
		}

		if ("9".equalsIgnoreCase(status)) {
			return "Gelöscht";
		}

		return "!!unbekannter interner Status!!";
	}

}
