/*
 * Segment 7 (Ste), SWE TMC-Meldungsverwaltung
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This programm is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.ste.tmcvew;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.ClientDavInterface;

/**
 * Junit-Test für Testfall 3 der Prüfspezifikation. Ein laufendes Kernsystem
 * wird vorausgesetzt.
 * 
 * 
 * Erstellt auf Basis der SWE RDS/TMC-Meldungen von: Dambach Werke GmbH, Stefan
 * Sans
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: $
 */
public class RdsMeldungTest3 {
	/**
	 * Datenverteilerverbindung.
	 */
	private static ClientDavInterface connection;

	private static RdsMeldung m;

	/**
	 * Aufbau der Datenverteilerverbindung.
	 * 
	 * @throws Exception
	 *             kann durch verschiedene Quellen erzeut werden.
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		m = new RdsMeldung();

		connection = m.prozessStart(connection, "Starte Testfall 3 ");

	}

	/**
	 * Abbau der Datenverteilerverbindung.
	 * 
	 * @throws Exception
	 *             kann durch verschiedene Quellen erzeut werden.
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		m.prozessStop();
		if (connection != null) {
			connection.disconnect(false, "");
		}
	}

	/**
	 * Instanz auf die zu prüfende Klasse.
	 * 
	 * @throws Exception bei Fehlern
	 */
	@Before
	public void setUp() throws Exception {
		m.iniRdsMeldung(connection);
	}

	/**
	 * Testfall.
	 */
	@Test
	public void testTestfall() {

		try {
			assertTrue("Test 3", m.testfall(connection, "Testfall3", 1));
			// assertTrue(m.testfall( m_connection,"Testfall2") );
		} catch (final Exception e) {
			assertEquals("Test 3", e.getMessage(), "Ungültige Exeption geworfen");
		}
	}

}
