/**
 * 
 */
package de.bsvrz.ste.tmcvew;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import de.bsvrz.dav.daf.main.ClientDavInterface;

/**
 * Junit-Test für Testfall 5 der Prüfspezifikation. Ein laufendes Kernsystem
 * wird vorausgesetzt.
 * 
 * Erstellt auf Basis der SWE RDS/TMC-Meldungen von: Dambach Werke GmbH, Hilpp
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: $
 */

public class RdsMeldungTest5 {
	/**
	 * Datenverteilerverbindung.
	 */
	private static ClientDavInterface m_connection = null;
	private static RdsMeldung m;

	/**
	 * Aufbau der Datenverteilerverbindung.
	 * 
	 * @throws Exception
	 *             kann durch verschiedene Quellen erzeut werden.
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		m = new RdsMeldung();

		m_connection = m.prozessStart(m_connection, "Starte Testfall 5 ");

	}

	/**
	 * Abbau der Datenverteilerverbindung.
	 * 
	 * @throws Exception
	 *             kann durch verschiedene Quellen erzeut werden.
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		m.prozessStop();
		if (m_connection != null) {
			m_connection.disconnect(false, "");
		}
	}


	@Before
	public void setUp() throws Exception {
		m.iniRdsMeldung(m_connection);
	}

	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Testfall.
	 */
	@Test
	public void testTestfall() {

		try {
			assertTrue("Test 5", m.testfall(m_connection, "Testfall5", 1));
			// assertTrue(m.testfall( m_connection,"Testfall2") );
		} catch (Exception e) {
			// TODO Auto-generated catch block
			assertEquals("Test 5", e.getMessage(), "Ungültige Exeption geworfen");
		}
	}

}
