/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Contact Information:
 * Dambach-Werke GmbH
 * Elektronische Leitsysteme
 * Fritz-Minhardt-Str. 1
 * 76456 Kuppenheim
 * Phone: +49-7222-402-0
 * Fax: +49-7222-402-200
 * mailto: info@els.dambach.de
 */

package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavConnection;

/**
 * Klasse instanziert die RDS-Meldungen f�r jedes RDS-objekt. Sie empf�ngt �ber
 * eine Listenerfunktionalit�t die RDS-Meldungen.
 * 
 * @author Dambach Werke GmbH
 * @version $Revision: 1.1 $ / $Date: 2008/10/29 12:09:03 $ / ($Author: Hilpp $)
 */
public class RdsMeldungsAuswertung {
	/**
	 * Debug M�glichkeit
	 */
	private boolean _debug = false;

	/**
	 * Pid des Objekts
	 */
	private String m_pid = null;

	/**
	 * Eigenschaften des Staus
	 */
	private RdsMeldungsEmpfang m_rdsmeldung = null;

	/**
	 * Verbindung zum DaV
	 */
	private ClientDavConnection m_connection = null;

	private long m_flag = 0;

	/**
	 * Konstruktor der Klasse:
	 */

	public RdsMeldungsAuswertung() {
	}

	/**
	 * Konstruktor der Klasse: Meldet sich über eine Listenerfunktionalität auf
	 * die RDS-Meldungen an Instanziert due Objekte "RdsMeldungsEmpfang"
	 * 
	 * @param connection
	 *            Verbindung zum DaV
	 * @param pid
	 *            Pid vom Typ "typ.rdsMeldung"
	 */
	public RdsMeldungsAuswertung(ClientDavConnection connection, String pid) {
		m_connection = connection;
		m_pid = pid;

		// am Listener anmelden
		m_rdsmeldung = new RdsMeldungsEmpfang(m_connection, pid);

		m_rdsmeldung.addListener(new INeueDatenListener() {
			public void neueDaten() {
				setFlag();
				System.out.println("RdsmeldungsAuswertungen -> RDS-Meldung empfangen  ");
			}
		});
	}

	public RdsMeldungsEmpfang getParameter() {
		return m_rdsmeldung;
	}

	public long getFlag() {
		return m_flag;
	}

	public long setFlag() {
		return m_flag++;
	}

	/**
	 * Methode liefert die PID des Objektes
	 * 
	 * @return pid Stauobjekt
	 */
	public String getPid() {
		return m_pid;
	}

	/**
	 * Methode ermittelt die Lage der Stauwurzel relativ zum Routenanfang.
	 * Ergebnis in Meter
	 */

	/**
	 * Methode zum L�schen dieser Stauprognose. Dabei werden alle angemeldeten
	 * Listener und die Verbindungen zum DaV gel�scht.
	 */
	public void dispose() {
		// Staueigenschaften

		m_rdsmeldung.dispose();
	}

}
