/*
 * Segment 7 (Ste), SWE TMC-Meldungsverwaltung
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This programm is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.SystemObject;

public class TestParameterHandler implements ClientSenderInterface {
	private ClientDavInterface dav;
	private String lmspid;

	private String meldungsAktionGesichert;
	private boolean angemeldet;
	private long meldungsRueckhaltungGesichert;

	public TestParameterHandler(final ClientDavInterface dav, final String lmspid) {
		super();
		this.dav = dav;
		this.lmspid = lmspid;
	}

	private Data getAktuelleDaten() {
		final ConfigurationObject lms = (ConfigurationObject) dav.getDataModel().getObject(lmspid);

		final AttributeGroup atg = dav.getDataModel().getAttributeGroup("atg.tmcMeldungsVerwaltung");
		final Aspect asp = dav.getDataModel().getAspect("asp.parameterSoll");
		final DataDescription dd = new DataDescription(atg, asp);

		final ResultData data = dav.getData(lms, dd, 0);
		return data.getData().createModifiableCopy();
	}
	
	private void sendeDaten(final Data daten) {
		final ConfigurationObject lms = (ConfigurationObject) dav.getDataModel().getObject(lmspid);

		final AttributeGroup atg = dav.getDataModel().getAttributeGroup("atg.tmcMeldungsVerwaltung");
		final Aspect asp = dav.getDataModel().getAspect("asp.parameterVorgabe");
		final DataDescription dd = new DataDescription(atg, asp);
		
		final ResultData data = new ResultData(lms, dd, System.currentTimeMillis(), daten);
		
		if (!angemeldet) {
		try {
			dav.subscribeSender(this, lms, dd, SenderRole.sender());
			angemeldet = true;
		} catch (OneSubscriptionPerSendData e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		}
		try {
			dav.sendData(data);
		} catch (DataNotSubscribedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SendSubscriptionNotConfirmed e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	
	public void setzeTestParameter() {
		final Data neueDaten = getAktuelleDaten();
		
		meldungsAktionGesichert = new String(neueDaten.getTextValue("RDSMeldungsAktion").getText());
		meldungsRueckhaltungGesichert = neueDaten.getUnscaledValue("RDSMeldungsRückhaltung").longValue();
		
		neueDaten.getTextValue("RDSMeldungsAktion").setText("0");
		neueDaten.getUnscaledValue("RDSMeldungsRückhaltung").set(120);

		sendeDaten(neueDaten);
	}

	@Override
	public void dataRequest(final SystemObject object, final DataDescription dataDescription, final byte state) {
	}

	@Override
	public boolean isRequestSupported(final SystemObject object, final DataDescription dataDescription) {
		// TODO Auto-generated method stub
		return false;
	}

	public void restoreParameter() {
		final Data neueDaten = getAktuelleDaten();
		
		neueDaten.getTextValue("RDSMeldungsAktion").setText(meldungsAktionGesichert);
		neueDaten.getUnscaledValue("RDSMeldungsRückhaltung").set(meldungsRueckhaltungGesichert);

		sendeDaten(neueDaten);
	}
}
