/*
 * Segment 7 (Ste), SWE TMC-Meldungsverwaltung
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This programm is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;

/**
 * Verwaltungsmodul für JUnit-Tests.
 * 
 * 
 * Erstellt auf Basis der SWE RDS/TMC-Meldungen von: Dambach Werke GmbH, Timo Pittner
 * 
 * @author BitCtrl Systems GmbH, Gieseler
 * @version $Id: $
 */

public interface Verwaltung {
	
	/**
	 * Erzeugt ein dynamisches Objekt.
	 * 
	 * @param pid PID
	 * @param name Name
	 * @param set Menge
	 * 
	 * @return <code>true</code>, wenn erfolgreich erzeugt, sonst <code>false</code>
	 */
	boolean erzeuge(String pid, String name, String set);
	
	/**
	 * Erzeugt ein dynamisches Objekt mit Daten.
	 * 
	 * @param pid PID
	 * @param name Name
	 * @param set Menge
	 * @param data Daten
	 * 
	 * @return <code>true</code>, wenn erfolgreich erzeugt, sonst <code>false</code>
	 */
	boolean erzeugeObjekt(String pid, String name, String set, Data[] data);

	/**
	 * Löscht ein dynamisches Objekt.
	 * 
	 * @param pid PID
	 * @return  <code>true</code>, wenn erfolgreich gelöscht, sonst <code>false</code>
	 */
	boolean loesche(String pid);

	/**
	 * Fügt das Objekt einer Menge hinzu.
	 * 
	 * @param set Menge
	 * @return <code>true</code>, wenn erfolgreich hinzugefügt, sonst <code>false</code>
	 */
	boolean hinzufuegeZuMenge(final String set);

	/**
	 * Entfernt das Objekt aus einer Menge.
	 *  
	 * @param set Menge
	 * @return <code>true</code>, wenn erfolgreich entfernt, sonst <code>false</code>
	 */
	boolean entferneVonMenge(final String set);

	/**
	 * Sendet Daten an das Objekt.
	 * 
	 * @param dd {@link DataDescription}
	 * @param resultData {@link ResultData}
	 * @return <code>true</code>, wenn erfolgreich gesendet, sonst <code>false</code>
	 */
	boolean parametriere(DataDescription dd, ResultData resultData);

	/**
	 * Setzt KOnfigurationsdaten des Objektes.
	 * 
	 * @param resultData {@link ResultData}
	 * @return <code>true</code>, wenn erfolgreich gesetzt, sonst <code>false</code>
	 */
	boolean konfiguriere(ResultData resultData);
}
