package de.bsvrz.ste.tmcvew;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObject;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.dynobj.DynamischeObjekte;

/**
 * Kommentar
 * 
 * @version $Revision: 1.1 $ / $Date: 2008/10/29 12:09:03 $ / ($Author: Hilpp $)
 * @author Dambach-Werke GmbH
 * @author Timo Pittner
 */
public class VerwaltungDynObj implements Verwaltung, ClientSenderInterface {
	private static Debug _debug;

	protected DataModel _dm;

	private ConfigurationArea _ca;

	private DynamicObjectType _dot;

	private ConfigurationObject _cal;

	private AttributeGroup _atg;

	private Aspect _asp;

	private DynamicObject _dynamicObject;

	private Boolean flag;

	private ClientDavInterface _con;

	private ResultData _konfData;

	/** Klasse zum Verwalten dynamischer Objekte. */
	private DynamischeObjekte vdo;

	public VerwaltungDynObj(DataModel dm, ConfigurationArea ca, DynamicObjectType dot, ConfigurationObject cal,
			AttributeGroup atg, Aspect asp) {
		this._dm = dm;
		this._ca = ca;
		this._dot = dot;
		this._cal = cal;
		this._atg = atg;
		this._asp = asp;
		_debug = Debug.getLogger();
	}

	public VerwaltungDynObj(ClientDavInterface con, DataModel dm, ConfigurationArea ca, DynamicObjectType dot,
			ConfigurationObject cal, AttributeGroup atg, Aspect asp) {
		this._con = con;
		this._dm = dm;
		this._ca = ca;
		this._dot = dot;
		this._cal = cal;
		this._atg = atg;
		this._asp = asp;
		_debug = Debug.getLogger();
		vdo = DynamischeObjekte.getInstanz(con);
	}

	@Override
	public boolean hinzufuegeZuMenge(final String set) {
		try {
			// _cal.getMutableSet(set).add(_dynamicObject);
			_cal.getObjectSet(set).add(_dynamicObject);

		} catch (Exception e) {
			e.getStackTrace();
		}
		return true;
	}

	public boolean loesche(String pid) {
		SystemObject so = _dm.getObject(pid);

		if (so != null) {

			// System.out.println("Objekt " + so.getPid() + " vorhanden,
			// loesche!");

			_dynamicObject = (DynamicObject) _dm.getObject(pid);

			if (_dynamicObject != null) {
				try {
					_dynamicObject.invalidate();

					// System.out.println("Objekt " + _dynamicObject.getPid() +
					// " geloescht!");
				} catch (ConfigurationChangeException e) {
					e.printStackTrace();
				}
			}

		} else {
			System.out.println("Objekt " + pid + " nicht vorhanden");
			return false;
		}
		return true;
	}

	public boolean erzeuge(String pid, String name, String set, Data[] data) {
		try {
			if (_dot == null) {
				System.out.println("DynamicObjectType nicht vorhanden!");
				return false;
			}

//			AttributeGroupUsage atgu = _atg.getAttributeGroupUsage(_asp);
//
//			DataAndATGUsageInformation daaui = null;
//
//			Collection<DataAndATGUsageInformation> col = new ArrayList<DataAndATGUsageInformation>();
//
//			if (data != null) {
//
//				for (Data d : data) {
//					daaui = new DataAndATGUsageInformation(atgu, d);
//
//					col.add(daaui);
//				}
//
//				System.out.println(_dot.getPid() + " " + pid + " " + name + " " + daaui.getData() + " "
//						+ daaui.getAttributeGroupUsage());

				final SystemObject obj = _dm.getObject(pid);
				if (obj == null) {
					// _dynamicObject = _ca.createDynamicObject(_dot, pid, name, col);
					_dynamicObject = vdo.erzeugeObjekt(_dot, name, pid);
				} else {
					System.out.println("DynObject '" + obj.getPid() + "'" + " schon vorhanden");
					return false;
				}
//			} else {
//				SystemObject obj = _dm.getObject(pid);
//				if (obj == null) {
//					_dynamicObject = _ca.createDynamicObject(_dot, pid, name);
//				} else {
//					System.out.println("DynObject '" + obj.getPid() + "'" + " schon vorhanden");
//					return false;
//				}
//			}
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}

		return true;
	}

	public void dataRequest(SystemObject arg0, DataDescription arg1, byte arg2) {
		// System.out.println("SenderAnfrage : Objekt " + arg0.getPid() + " dd "
		// + arg1 + " state " + arg2);

		if (arg2 == 0) {
			flag = true;
			synchronized (this) {
				notify();
			}
		}

	}

	public boolean isRequestSupported(SystemObject arg0, DataDescription arg1) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean parametriere(final DataDescription dd, final ResultData resultData) throws IllegalArgumentException {
		if (dd == null || resultData == null) {
			throw new IllegalArgumentException();
		}

		try {
			_debug.config("send1 : " + resultData.getData());
			getConnection().sendData(resultData);

		} catch (DataNotSubscribedException e) {
			// e.printStackTrace();

			try {
				_debug.config("subscribe!");
				getConnection().subscribeSender(this, resultData.getObject(), dd, SenderRole.sender());

			} catch (OneSubscriptionPerSendData e1) {
				e1.printStackTrace();
			}
			try {

				flag = false;

				synchronized (this) {

					while (!flag) {

						try {
							this.wait();
						} catch (final InterruptedException e1) {
							e1.printStackTrace();
						}
					}
				}

				try {
					Thread.sleep(1000);
				} catch (final InterruptedException e1) {
					e1.printStackTrace();
				}

				_debug.config("send2 : " + resultData.getData());
				getConnection().sendData(resultData);
				// _debug.config("send : " + resultData.getData());
			} catch (DataNotSubscribedException e1) {
				e1.printStackTrace();
			} catch (SendSubscriptionNotConfirmed e1) {
				e1.printStackTrace();
			}
		} catch (SendSubscriptionNotConfirmed e) {
			e.printStackTrace();
		}

		return true;
	}

	@Override
	public boolean entferneVonMenge(final String set) {
		try {
			// _cal.getMutableSet(pid).remove(_dynamicObject);

			_cal.getObjectSet(set).remove(_dynamicObject);
		} catch (Exception e) {
			e.getStackTrace();
		}
		return true;
	}

	/**
	 * @return Returns the dynamicObject.
	 */
	public DynamicObject getDynamicObject() {
		return _dynamicObject;
	}

	/**
	 * @param dynamicObject
	 *            The dynamicObject to set.
	 */
	public void setDynamicObject(DynamicObject dynamicObject) {
		_dynamicObject = dynamicObject;
	}

	/**
	 * @return {@link ClientDavInterface}
	 */
	public ClientDavInterface getConnection() {
		return _con;
	}

	/**
	 * @param connection {@link ClientDavInterface}
	 */
	public void setConnection(ClientDavInterface connection) {
		_con = connection;
	}

	public boolean konfiguriere(ResultData resultData) {
		_konfData = resultData;

		return true;
	}

	public boolean erzeuge(String pid, String name, String set) {
		// TODO Auto-generated method stub
		return false;
	}

	public boolean erzeugeObjekt(String pid, String name, String set, Data[] data) {
		return erzeuge(pid, name, set, data);
	}

}
